% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{isNLclass}
\alias{isNLclass}
\alias{isNLclass,matrix,character-method}
\title{Type of object}
\usage{
isNLclass(agents, class)

\S4method{isNLclass}{matrix,character}(agents, class)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{class}{Character. Can take one of the following options to define
the \code{class}: \code{"agent"}, \code{"agentset"},
\code{"patch"}, \code{"patchset"}. \code{"turtle"} or \code{"turtleset"}.}
}
\value{
Logical. \code{TRUE} if \code{agents} is of the \code{class} tested.
}
\description{
Report \code{TRUE} if the \code{agents} is of the \code{class} tested,
report \code{FALSE} otherwise.
}
\details{
Careful! The \code{class} tested does not correspond to actual R classes.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     `agents` is `"patch"` if it is a matrix (`ncol` = 2) with the
     first column `pxcor` and the second column `pycor` with only
     one row. `agents` is `"patcheset"` if the matrix has more than
     one row.

     `agents` is `"turtle"` if it is an `agentMatrix`
     containing only one `turtle`.
     `agents` is `"turtleset"` if the
     `agentMatrix` contains more than one `turtle`.

     `agents` is `"agent"` if it is either `"patch"` or
     `"turtle"`. `agents` is `"agentset"` if it is either
     `"patcheset"` or `"turtleset"`.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:3, size = 10, replace= TRUE))
isNLclass(agents = patches(w1), class = "patch")
isNLclass(agents = patches(w1), class = "patcheset")
isNLclass(agents = t1, class = "agentset")
isNLclass(agents = t1, class = "turtleset")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#is-of-type}
}
\author{
Sarah Bauduin
}
