% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{simuTargetClutter}
\alias{simuTargetClutter}
\title{Simulate A Moving Target in Clutter}
\usage{
simuTargetClutter(nobs, pd, ssw, ssv, xx0, ss0, nyy, yrange)
}
\arguments{
\item{nobs}{the number observations.}

\item{pd}{the probability to observe the true signal.}

\item{ssw}{the standard deviation in the state equation.}

\item{ssv}{the standard deviation for the observation noise.}

\item{xx0}{the initial location.}

\item{ss0}{the initial speed.}

\item{nyy}{the dimension of the data.}

\item{yrange}{the range of data.}
}
\value{
The function returns a list with components:
\item{xx}{the location.}
\item{ss}{the speed.}
\item{ii}{the indicators for whether the observation is the true signal.}
\item{yy}{the data.}
}
\description{
The function simulates a target signal under clutter environment.
}
\examples{
data=simuTargetClutter(30,0.5,0.5,0.5,0,0.3,3,c(-30,30))
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
