% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadTab.R
\name{NMreadTab}
\alias{NMreadTab}
\title{Read an output table file from Nonmem}
\usage{
NMreadTab(
  file,
  col.tableno,
  col.nmrep,
  col.table.name,
  header = TRUE,
  skip,
  quiet = TRUE,
  as.fun,
  ...
)
}
\arguments{
\item{file}{path to Nonmem table file}

\item{col.tableno}{In case of simulations where tables are being
repeated, a counter of the repetition number can be useful to
include in the output. For now, this will only work if the
NOHEADER option is not used. This is because NMreadTab
searches for the "TABLE NO..." strings in Nonmem output
tables. If col.tableno is TRUE (default), a counter of tables
is included as a column called NMREP. Notice, the table
numbers in NMREP are cumulatively counting the number of
tables reported in the file. NMREP is not the actual table
number as given by Nonmem.}

\item{col.nmrep}{col.nmrep If tables are repeated, include a
counter? It does not relate to the order of the $TABLE
statements but to cases where a $TABLE statement is run
repeatedly. E.g., in combination with the SUBPROBLEMS feature
in Nonmem, it is useful to keep track of the table
(repetition) number. If col.nmrep is TRUE, this will be
carried forward and added as a column called NMREP. This is
default behavior when more than one $TABLE repetition is found
in data. Set it to a different string to request the column
with a different name. The argument is passed to NMscanTables.}

\item{col.table.name}{The name of a column containing the name or
description of the table (generated by Nonmem). The default is
"table.name". Use FALSE not to include this column.}

\item{header}{Use header=FALSE if table was created with NOHEADER
option in $TABLE.}

\item{skip}{The number of rows to skip. The default is skip=1 if
header==TRUE and skip=0 if header==FALSE.}

\item{quiet}{logical stating whether or not information is printed
about what is being done. Default can be configured using
NMdataConf.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{...}{Arguments passed to fread.}
}
\value{
The Nonmem table data.
}
\description{
Read a table generated by a $TABLE statement in Nonmem. Generally,
these files cannot be read by read.table or similar because
formatting depends on options in the $TABLE statement, and because
Nonmem sometimes includes extra lines in the output that have to
be filtered out. NMreadTab can do this automatically based on the
table file alone.
}
\details{
The actual reading of data is based on
    data.table::fread. Generally, the function is fast thanks to
    data.table.
}
\seealso{
Other DataRead: 
\code{\link{NMreadCsv}()},
\code{\link{NMscanData}()},
\code{\link{NMscanInput}()},
\code{\link{NMscanTables}()}
}
\concept{DataRead}
