% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pathfinder.R
\name{generatePerturbations}
\alias{generatePerturbations}
\title{Generate Perturbations}
\usage{
generatePerturbations(training, tp, iterations = 20, spline = 3,
  knots = 100, numPert = 20)
}
\arguments{
\item{training}{This is a numerical matrix of training data, where the rows represent different samples, columns represent different time points (or points on a single spatial axis), and the values correspond to measurements}

\item{tp}{A numerical vector of time points (or spatial coordinates along a single axis)}

\item{iterations}{a positive integer, representing the maximum number of iterations employed during time warping (see time_warping in fdasrvf library)}

\item{spline}{a positive integer, representing the degree of the B-spline interpolation when calculating values at the new, evenly spaced knot positions}

\item{knots}{a positive integer-- for time warping to work optimally, the points must be evenly sampled.  This determines how many points do we evenly sample before conducting time warping}

\item{numPert}{a positive integer, representing the number of sampled curves to output.}
}
\value{
An fdawarp object (see fdasrvf library)
}
\description{
Find curves similar to a set of example curves.  This function takes as input a set of example curves, and uses them to infer a probability distribution of curves.  \code{numPert} curves are sampled from this probability distribution.
}
\examples{
mat=CanadianWeather$monthlyTemp
\donttest{generated=generatePerturbations(mat, c(1:length(mat[,1])))}
}
