% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestaic.R
\name{bestaic}
\alias{bestaic}
\title{Find the lowest AIC multiple regression model}
\usage{
bestaic(y.var, cen.var, x.vars, LOG = TRUE, n.models = 10)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits.}

\item{cen.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value is in \code{y.var}.}

\item{x.vars}{One or more uncensored explanatory variable(s). See Details}

\item{LOG}{Indicator of whether to compute the regression in the original y units, or on their logarithms.  The default is to use the logarithms (\code{LOG = TRUE}).  To compute in original units, specify the option \code{LOG = FALSE} (or \code{LOG = 0}).}

\item{n.models}{The number of models with their AIC values to be printed in the console window.  All (2^k-1) models are computed internally. This sets how many "best" (lowest AIC) models have output printed to the console.}
}
\value{
Prints number of \code{x.vars}, lists \code{x.vars} and AIC values.
}
\description{
Computes (2^k-1) censored regression models and their AIC statistics.  Prints out the lowest AIC models and the terms used.
}
\details{
\code{x.vars}: If 1 x variable only, enter its name.  If multiple x variables, enter the name of a data frame of columns of the x variables. No extra columns unused in the regression allowed. Create this by \code{x.frame <- data.frame (Temp, Flow, Time)} for 3 variables (temperature, flow and time).

AIC of each model is printed from lowest to highest AIC to help evaluate the ‘best’ regression model. n.models determines how many lines of model info is printed.

LOG: The default is that the Y variable will be log transformed (LOG = TRUE).
}
\examples{

data(Brumbaugh)

# Multiple regression
bestaic(Brumbaugh$Hg, Brumbaugh$HgCen, Brumbaugh[, c("SedMeHg","PctWetland", "SedAVS")])
}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
\seealso{
\link[survival:survreg]{survival::survreg}
}
