% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dendograma.R
\name{Dendograma}
\alias{Dendograma}
\title{Dendograma}
\usage{
Dendograma(Dissimilaridade,Metodo)
}
\arguments{
\item{Dissimilaridade}{Matriz contendo a estimativa das distancias entre
tratamentos.}

\item{Metodo}{Valor numerico indicando o metodo a ser utilizado:
 \itemize{
\item  1 = Ligacao simples (Metodo do vizinho mais proximo).
\item  2 = Ligacao completa (Metodo do vizinho distante).
 \item  3 = Ligacao media entre grupo (UPGMA).
 \item  4 = Metodo de Ward.
 \item  5 = Metodo de ward (d²).
 \item  6= Metodo da mediana (WPGMC).
 \item  7= Metodo do centroide (UPGMC).
 \item  8 = Metodo mcquitty (WPGMA).
 }}
}
\value{
A funcao retorna o dendograma, distancias feneticas e correlacao
  cofenetica.
}
\description{
Esta funcao retorna a figura do dendograma, distancias feneticas
  e correlacao cofenetica.
}
\examples{
data(Dados.MED)
Dist=Distancia(Dados.MED,2)
Dendograma(Dist,2)
}
\references{


PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{hclust}}, \code{\link{dist}}
}
