% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{generateTVGraph}
\alias{generateTVGraph}
\title{Marginal imbalance vs. exclusion}
\usage{
generateTVGraph(matchingResult)
}
\arguments{
\item{matchingResult}{an object returned by the main matching function
distBalMatch}
}
\value{
No return value, called for visualization of match result
}
\description{
Plotting function that visualizes the tradeoff between the total
variation imbalance on a specified variable and the number of unmatched
treated units. This function only works for the 'Basic' version of matching
(conducted using \code{distBalMatch}).
}
\examples{
## Generate matches 
data("lalonde", package="cobalt")
psCols <- c("age", "educ", "married", "nodegree")
treatVal <- "treat"
responseVal <- "re78"
pairDistVal <- c("age", "married", "educ", "nodegree")
exactVal <- c("educ")
myBalVal <- c("race")
r1s <- c( 0.1, 0.3, 0.5, 0.7, 0.9,1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7)
r2s <- c(0.01)
matchResult <- distBalMatch(df=lalonde, treatCol=treatVal, myBalCol=myBalVal,
rhoExclude =r1s, rhoBalance=r2s,
distList=pairDistVal, exactlist=exactVal,
propensityCols = psCols,ignore = c(responseVal), maxUnMatched = 0.1,
caliperOption=NULL, toleranceOption=1e-1, maxIter=0, rho.max.f = 10)

## Generate visualization of tradeoff between total variation distance and 
## number of treated units left unmatched
generateTVGraph(matchResult)
}
\seealso{
Other Graphical helper functions for analysis: 
\code{\link{generatePairdistanceBalanceGraph}()},
\code{\link{generatePairdistanceGraph}()}
}
\concept{Graphical helper functions for analysis}
