% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{Bias_Correc_VAR}
\alias{Bias_Correc_VAR}
\title{Estimates an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)}
\usage{
Bias_Correc_VAR(
  ModelType,
  BRWinputs,
  RiskFactors,
  N,
  Economies,
  FactorLabels,
  GVARinputs = NULL,
  JLLinputs = NULL,
  ev_restr = 1,
  nargout = 4
)
}
\arguments{
\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{BRWinputs}{A list containing the necessary inputs for the BRW model estimation:
\enumerate{
\item \code{flag_mean}: Logical. Determines whether mean- (TRUE) or median- (FALSE) unbiased estimation is desired. Default is TRUE.
\item \code{gamma}: Numeric. Adjustment parameter between 0 and 1. Default is 0.5.
\item \code{N_iter}: Integer. Number of iterations for the stochastic approximation algorithm after burn-in. Default is 5,000.
\item \code{N_burn}: Integer. Number of burn-in iterations. Default is 15% of \code{N_iter}.
\item \code{B}: Integer. Number of bootstrap samples per iteration for calculating the noisy measure of the OLS estimator's mean or median. Default is 50.
\item \code{check}: Logical. Indicates whether to perform a closeness check. Default is TRUE.
\item \code{B_check}: Integer. Number of bootstrap samples for the closeness check. Default is 100,000.
}}

\item{RiskFactors}{A numeric matrix (T x F) representing the time series of risk factors.}

\item{N}{Integer. Number of country-specific spanned factors.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{GVARinputs}{List. Inputs for GVAR model estimation (see \code{\link{GVAR}} function). Default is NULL.}

\item{JLLinputs}{List. Inputs for JLL model estimation (see \code{\link{JLL}} function). Default is NULL.}

\item{ev_restr}{Numeric. Restriction on the largest eigenvalue under the P-measure. Default is 1.}

\item{nargout}{Integer. Number of elements in the output list. Default is 4.}
}
\value{
Bias-corrected VAR paramaters based on the framework of Bauer, Rudebusch and Wu (2012). The list contains:
\enumerate{
\item \code{Phi_tilde}: estimated coefficient matrix (F x F);
\item \code{mu_tilde}: estimated intercept (F x 1);
\item \code{V_tilde}: estimated variance-covariance matrix (F x F);
\item \code{dist}: root mean square distance (scalar);
\item \code{Phi_sample}: sample estimated variance-covariance matrix used in the checks (F x F x B_check) - this output is
     reported if nargout is 5.
}
}
\description{
Estimates an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)
}
\examples{
\donttest{
data(CM_Factors)
Factors <- t(RiskFactors[1:7,])

BRWinputs <- list(flag_mean = TRUE, gamma = 0.4, N_iter = 1000, N_burn = 100,
                  B = 10, check = 1, B_check = 5000)

Economies <- "China"
N <- 3
ModelType <- "JPS original"
FactorLabels <- NULL


BRWpara <- Bias_Correc_VAR(ModelType, BRWinputs, Factors, N, Economies, FactorLabels)
}

}
\references{
Bauer, Rudebusch and, Wu (2012). "Correcting Estimation Bias in Dynamic Term Structure Models" \cr
This function is based on the \code{est_unb_var} Matlab function available at Cynthia Wu's website
(https://sites.google.com/view/jingcynthiawu/).
}
