\name{update.mplusObject}
\alias{update.mplusObject}
\title{Update an Mplus model object}
\usage{
  \method{update}{mplusObject} (object, ...)
}
\arguments{
  \item{object}{An object of class mplusObject}

  \item{\dots}{Additional arguments to pass on}
}
\value{
  An (updated) Mplus model object
}
\description{
  This is a method for updating an Mplus model object. It
  takes an Mplus model object as the first argument, and
  then optionally any sections to update. There are two
  ways to update a section using a formula interface.
  \code{~ "new stuff"} will replace a given section with
  the new text.  Alternately, you can add additional text
  using \code{~ + "additional stuff"}. Combined these let
  you replace or add to a section.
}
\examples{
example1 <- mplusObject(MODEL = "mpg ON wt;",
  usevariables = c("mpg", "hp"), rdata = mtcars)
x <- ~ "ESTIMATOR = ML;"
str(update(example1, rdata = iris))
str(update(example1, ANALYSIS = x))
str(update(example1, MODEL = ~ "wt ON hp;"))
str(update(example1, MODEL = ~ . + "wt ON hp;"))
str(update(example1, ANALYSIS = x, MODEL = ~ . + "wt ON hp;"))

# test to make sure . in Mplus code does not cause problems
str(update(example1, ANALYSIS = x, MODEL = ~ . + "wt ON hp*.5;"))
rm(example1, x)
}
\author{
  Joshua Wiley
}
\keyword{interface}

