% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-tracks.R
\name{brownianTrack}
\alias{brownianTrack}
\title{Simulate an Uncorrelated Random Walk}
\usage{
brownianTrack(nsteps = 100, dim = 3, mean = 0, sd = 1)
}
\arguments{
\item{nsteps}{desired number of steps (e.g. 10 steps generates a track with 11 positions).}

\item{dim}{desired number of dimensions.}

\item{mean}{stepwise mean drift per dimension; use 0 for an 
unbiased Brownian motion and other values for Brownian motion with drift.}

\item{sd}{stepwise standard deviation per dimension.}
}
\value{
A data frame  containing in cell track with \code{nsteps} steps in 
\code{dim} dimensions is returned.

## The Hurst exponent of a 1D Brownian track should be near 0.5
hurstExponent( brownianTrack( 100, 1 ) )
}
\description{
Generates a random track with \code{nsteps} steps in \code{dim} dimensions.
}
\details{
In in every step an for each dimension, a normally distributed 
value with mean \code{mean} and standard deviation \code{sd} is 
added to the previous cell position.
}

