% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{integralJointMoTBF}
\alias{integralJointMoTBF}
\title{Integration with MoTBFs}
\usage{
integralJointMoTBF(P, var = NULL)
}
\arguments{
\item{P}{A \code{"jointmotbf"} object.}

\item{var}{A \code{"character"} vector containing the name of the variables that will be integrated out.
Instead of the names, the position of the variables can be given.
By default it's \code{NULL} then all the variables are integrated out.}
}
\value{
A multiintegral of a joint function of class \code{"jointmotbf"}.
}
\description{
Integrate a \code{"jointmotbf"} object over an non defined domain. It is able to
get the integral of a joint function over a set of variables or over all
the variables in the function.
}
\examples{
## 1. EXAMPLE
## Dataset with 2 variables
X <- data.frame(rnorm(100), rnorm(100))

## Joint function
dim <- c(2,3)
param <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param)

## Integral
integralJointMoTBF(P)
integralJointMoTBF(P, var="x")
integralJointMoTBF(P, var="y")

##############################################################################
## MORE EXAMPLES #############################################################
##############################################################################
\donttest{
## Dataset with 3 variables
X <- data.frame(rnorm(50), rnorm(50), rnorm(50))

## Joint function
dim <- c(2,1,3)
param <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param)
 
## Integral
integralJointMoTBF(P)
integralJointMoTBF(P, var="x")
integralJointMoTBF(P, var="y")
integralJointMoTBF(P, var="z")
integralJointMoTBF(P, var=c("x","z"))
}
}
