% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmpcaClust_class.R
\docType{class}
\name{mmpcaClust-class}
\alias{mmpcaClust-class}
\title{mmpcaClust class}
\description{
An S4 class representing a fitted mmpca model.
}
\details{
The BB-CVEM method is the branch & bound greedy procedure proposed in
  the original paper of Jouvin et. al. \url{https://arxiv.org/abs/1909.00721}. The number of epochs in the \code{n_epochs} slot
  is actually the true number of pass minus 1 (unless \code{max.epochs} was
  reached). Indeed, the last pass before convergence does not change either
  the bound or the \code{clustering}, hence it is removed of the counter.
}
\section{Slots}{

\describe{
\item{\code{call}}{A \code{\link{call}} object specifying the call}

\item{\code{method}}{The method used in the call}

\item{\code{clustering}}{The final partition found by the algorithm}

\item{\code{controls}}{An object of class \code{\linkS4class{mmpcaClustcontrol}}
containing the controls used in the VEM algorithm on the aggregated DTM
during the loop. The slots \code{controls@control_lda_init} where only use
when init.beta == 'lda'.}

\item{\code{K}}{An integer specifying the number of topics.}

\item{\code{Q}}{An integer specifying he number of clusters.}

\item{\code{N}}{An integer specifying the number of observations.}

\item{\code{V}}{An integer specifying the number of variables.}

\item{\code{beta}}{The (KxV) topic matrix.}

\item{\code{gamma}}{A (QxK) matrix containing the variational paramaters of the
variational distribution of each $\\theta_q$ in its rows.}

\item{\code{lda_algo}}{An object of class "\code{LDA}" (cf.
\code{\linkS4class{TopicModel}}) containing the results of the
\code{\link{LDA}}() function applied to the aggregated DTM,
with control \code{controls@control_lda_loop}}

\item{\code{max.epochs}}{The maximum number of pass through the whole dataset in the
algorithm.}

\item{\code{logLikelihoods}}{A numeric vector containing the evolution of the
variational bound every \code{keep} iteration.}

\item{\code{keep}}{An integer specifying the . Mostly useful for the plot function.}

\item{\code{n_epochs}}{The number of pass through the datasets before convergence.
see details}

\item{\code{llhood}}{The final value of the variational lower bound.}

\item{\code{Yinit}}{The value of the initial partition.}

\item{\code{icl}}{The Integrated Classification Likelihood value.}
}}

\section{Objects from the class}{

Object of class "\code{mmpcaClust}" are returned by
  \code{\link{mmpca_clust}}()
}

