% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.distance.R
\name{get.distance}
\alias{get.distance}
\title{Calculate Nei distance between two or more population}
\usage{
get.distance(
  population,
  type = "nei",
  marker = "all",
  per.marker = FALSE,
  gen1 = NULL,
  database1 = NULL,
  cohorts1 = NULL,
  gen2 = NULL,
  database2 = NULL,
  cohorts2 = NULL,
  database.list = NULL,
  gen.list = NULL,
  cohorts.list = NULL
)
}
\arguments{
\item{population}{population list}

\item{type}{Chose type of distance to compute (default: Neis standard genetic distance "nei"). Alt: Reynolds distance ("reynold"), Cavalli-Sforza ("cavalli"), Neis distance ("nei_distance"), Neis minimum distance ("nei_minimum")}

\item{marker}{Vector with SNPs to consider (Default: "all" - use of all markers)}

\item{per.marker}{Set to TRUE to return per marker statistics on genetic distances}

\item{gen1}{Quick-insert for database (vector of all generations to consider)}

\item{database1}{First Groups of individuals to consider}

\item{cohorts1}{Quick-insert for database (vector of names of cohorts to consider)}

\item{gen2}{Quick-insert for database (vector of all generations to consider)}

\item{database2}{Second Groups of individuals to consider}

\item{cohorts2}{Quick-insert for database (vector of names of cohorts to consider)}

\item{database.list}{List of databases to consider (use when working with more than 2 populations)}

\item{gen.list}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts.list}{Quick-insert for database (vector of names of cohorts to consider)}
}
\value{
Population list
}
\description{
Function to calculate Nei's distance between two or more population
}
\examples{
data(ex_pop)
get.distance(ex_pop, database1 = cbind(1,1), database2 = cbind(1,2))
}
