% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixtureMissing.R
\name{plot.MixtureMissing}
\alias{plot.MixtureMissing}
\title{Mixture Missing Plotting}
\usage{
\method{plot}{MixtureMissing}(x, ...)
}
\arguments{
\item{x}{A \code{MixtureMissing} object.}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\value{
No return value, called to visualize the fitted model's results
}
\description{
Provide a parallel plot of up to the first 10 variables of a multivariate
data sets, and a line plot showing log-likelihood values at every iteration
during the EM algorithm. When applicable, pairwise scatter plots highlighting
outliers denoted by triangles and/or observations whose values are missing but are replaced by
expectations obtained in the EM algorithm will be included.
}
\examples{

data('auto')

#++++ With no missing values ++++#

X <- auto[, c('engine_size', 'city_mpg', 'highway_mpg')]
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
plot(mod)

#++++ With missing values ++++#

X <- auto[, c('normalized_losses', 'horsepower', 'highway_mpg', 'price')]
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
plot(mod)

}
