% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplode.R
\name{xplode}
\alias{xplode}
\title{Extract values from a fitted GLMM object}
\usage{
xplode(model.obj, name.cont = NA, name.factor = NA, names.response = NA)
}
\arguments{
\item{model.obj}{The GLMM fitted with \code{glmer}. An object of class
\code{"\linkS4class{merMod}"}.}

\item{name.cont}{A string providing the name of the continuous predictor,
as in the formula object of the fitted model}

\item{name.factor}{A string providing the name of name of the categorical
predictor, as in the formula object of the fitted model}

\item{names.response}{Optional. A string providing the name of name of the
response variable, as in the formula object of the fitted model}
}
\description{
Extract values from an object of class \code{\linkS4class{merMod}}
(more specifically, from an object of subclass \code{glmerMod}).
}
\details{
For simplicity and maintenance reasons, several \code{MixedPsy} functions take as input an
 object of class \code{xplode} instead of an object of class \code{\linkS4class{merMod}}.
}
\examples{
library(lme4)
multi.mod <- glmer(cbind(faster, slower) ~ speed * vibration  + (1 + speed| subject), 
family = binomial(link = "probit"), data = vibro_exp3)
xplode.mod <- xplode(multi.mod, name.cont = "speed", name.factor = "vibration")
MixPlot(xplode.mod)
MixDelta(xplode.mod)

}
\seealso{
\code{\link[lme4]{merMod-class}} and \code{\link[lme4]{glmer}}.
\code{\link{MixDelta}}, \code{\link{MixPlot}} for use of objects of class \code{xplode}.
}
\keyword{GLMM}
