% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregLaplace.R
\name{mixregLap}
\alias{mixregLap}
\title{Robust Mixture Regression with Laplace Distribution}
\usage{
mixregLap(x, y, C = 2, nstart = 20, tol = 1e-05)
}
\arguments{
\item{x}{an n by p matrix of observations (one observation per row). The intercept will be automatically added to \code{x}.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated component standard deviations.}
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{lik}{final likelihood.}
\item{run}{total number of iterations after convergence.}
}
\description{
`mixregLap' provides robust estimation for a mixture of linear regression models
by assuming that the error terms follow the Laplace distribution (Song et al., 2014).
}
\examples{
data(tone)
y = tone$tuned          # length(y) = 160
x = tone$stretchratio   # length(x) = 160
k = 160
x[151:k] = 0
y[151:k] = 5
\donttest{est_lap = mixregLap(x, y, 2)}
}
\references{
Song, W., Yao, W., and Xing, Y. (2014). Robust mixture regression model fitting by Laplace distribution.
Computational Statistics & Data Analysis, 71, 128-137.
}
\seealso{
\code{\link{mixregT}} for robust estimation with t-distribution.
}
