% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KDEEM.R
\name{KDEEM}
\alias{KDEEM}
\title{Kernel Density-based EM type algorithm for Semiparametric Mixture Regression with Unspecified Error Distributions}
\usage{
KDEEM(x, y, M, ini, maxiter)
}
\arguments{
\item{x}{explanatory variables in matrix from with row as observations}

\item{y}{response variable}

\item{M}{number of component}

\item{ini}{initial values for parameters. ini = list(Beta = regression coefficients,
P = matrix: probability of each observation is from component m based on initial beta and H,
Tao =  precision parameter, the inverse of standard deviation
PI = component proportion
H = bandwidth for kernel estimation)
the initial value can be obtained by applying traditional MLE with EM algorithm and normal assumption.}

\item{maxiter}{maximum iteration for the algorithm}
}
\value{
P: posterior probability of each observation is from component m
Beta: estimated regression coefficients
Tao: Estimated precision parameter, the inverse of standard deviation.
PI: estimated component proportion
H: bandwidth of the kernel estimation
}
\description{
Unlike KDEEM.LSE and KDEEM.H, KDEEM is used for unspecified error distributions, can be applied for unspecified
error distribution (both homogeneous and heterogenous)
}
\examples{
Samplesize=300;
M=2 # M is the number of groups.
Dimen=2
Beta.true.matrix<-matrix(c(-3,3,3,-3),Dimen,M);
PI.true=c(0.5,0.5);
#simulate data
x=runif(Samplesize)
X=cbind(1,x);
n=Samplesize;
Group.ID=Rlab::rbern(n, prob=0.5);
Error=rnorm(n,0,1);
n1=sum(Group.ID);
n2=n-n1;

y=rep(0,Samplesize);
err=rep(0,n);

for(i in 1:n){
 if(Group.ID[i]==1)
 {err[i]=Error[i];
 y[i]=X[i,]\%*\%Beta.true.matrix[,1]+err[i];}
 else
 {err[i]=0.5*Error[i];
 y[i]=X[i,]\%*\%Beta.true.matrix[,2]+err[i];}
}

# Get initial value from MLE
Result.MLE= mixtools::regmixEM(y, x, arbmean = TRUE, arbvar = TRUE, epsilon = 1e-4);

Result.KDEEM.LSE = KDEEM.LSE(x,y,M,Result.MLE)

Result.KDEEM.H = KDEEM.H(x,y,M,Result.KDEEM.LSE,maxiter=3)

Result.KDEEM = KDEEM(x,y,M,Result.KDEEM.LSE,maxiter=3)
}
