% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_assess_quality_threshold.R
\name{miRNA_assessQualityThreshold}
\alias{miRNA_assessQualityThreshold}
\title{Assessment of quality threshold values.}
\usage{
miRNA_assessQualityThreshold(
  inputDataset,
  significanceLevel = 0.05,
  saveOutputFile = FALSE,
  outputFileName = "",
  sep = "\\t"
)
}
\arguments{
\item{inputDataset}{Dataset (data frame) to be used for the assessment. The data frame must comply with the output format of the preprocessing function (miRNA_expressionPreprocessing), thus containing the columns 'Subject', 'miRNA', 'Mean', 'StdDev', 'SampleSize' and possibly 'Class'. Any other column is ignored, and any missing column forbids execution.}

\item{significanceLevel}{Significance level to be used for the assessment (must be greater than zero and less than one). Default is 0.05 (i.e. 5 percent).}

\item{saveOutputFile}{Boolean option setting whether results are written to file (TRUE) or not (FALSE). Default is FALSE.}

\item{outputFileName}{Name of the output file where the quality threshold values are to be stored. If not assigned, a filename is automatically generated.}

\item{sep}{Field separator character for the output files; the default is tabulation.}
}
\value{
A data frame of quality threshold values, containing the columns 'miRNA' and 'QualityThreshold'.
}
\description{
This function assesses a set of quality threshold values (standard deviations), one for each miRNA, out of a dataset.
}
\examples{
requiredFile = paste(system.file(package="MiRNAQCD"), "/extdata/dataset_alpha_prep.dat", sep='')
myDataFrame <- read.table(file=requiredFile, header=TRUE)
qt <- miRNA_assessQualityThreshold(myDataFrame, significanceLevel=0.05)
}
