% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLoss.R
\name{logLoss}
\alias{logLoss}
\title{Log Loss/Binary Cross Entropy}
\usage{
logLoss(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values (0 or 1).}

\item{predicted}{Predicted values strictly larger than 0 and smaller than 1.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Calculates weighted logloss resp. cross entropy. Equals half of the unit Bernoulli deviance. The smaller, the better.
}
\examples{
logLoss(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8))
logLoss(c(1, 0, 0, 1), c(0.1, 0.1, 0.9, 0.8))
logLoss(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8), w = 1:4)
}
\seealso{
\code{\link{deviance_bernoulli}}.
}
