% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{validate_dataAcrossTips}
\alias{validate_dataAcrossTips}
\title{Validate Data Structure Across Tips}
\usage{
validate_dataAcrossTips(data)
}
\arguments{
\item{data}{A list structured as \code{data[[tip]][[structure]]}.}
}
\description{
This function ensures that \code{data} follows the required nested structure
\code{data[[tip]][[structure]]}, where:
\itemize{
\item \code{data} is a list of at least two \code{tip} elements.
\item Each \code{tip} is a list of \code{structure} elements.
\item Each \code{structure} contains a numeric vector of equal length across all tips.
}
}
\details{
Throws errors if:
\itemize{
\item \code{data} is not a list.
\item It has fewer than two tips.
\item Any tip is not a list.
\item The number of structures is inconsistent across tips.
\item Any structure has zero-length data at any tip.
\item Structures have different site lengths across tips.
}
}
