% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinPlot.R
\name{violinPlot}
\alias{violinPlot}
\title{Compare groups within a single dataset in a violin plot}
\usage{
violinPlot(filterObject, datasetObject, labelColumn = "label",
  comparisonMethod = "wilcox.test", pairwiseComparisons = TRUE,
  autoLineBreak = TRUE)
}
\arguments{
\item{filterObject}{a MetaFilter object containing the signature genes that will be used for the z-score calculation}

\item{datasetObject}{a Dataset object (typically independent validation dataset) for group comparison in a violin plot}

\item{labelColumn}{the label of the column in \code{$pheno} that specifies the groups to compare, typically case or control (default: 'label')}

\item{comparisonMethod}{statistical test that will be used (default="wilcox.test"). Other options include "t.test".}

\item{pairwiseComparisons}{if TRUE, perform pairwise statistical comparisons against the first factor level. If FALSE, perform global statistical comparisons (default: TRUE).}

\item{autoLineBreak}{if TRUE, insert line breaks into labels on plots. If FALSE, don't insert line breaks (default: TRUE)}
}
\value{
Returns a violin plot as ggplot2 plot object
}
\description{
Given a \code{filterObject} and a \code{datasetObject} this function will use the selected genes of the \code{filterObject} to calculate and compare the z-scores of the groups (e.g. cases vs. controls) from the \code{datasetObject} by generating a violin plot. A violin plot is similar to a box plot, except the width of each violin is proportional to the density of points. \code{violinPlot()} is commonly used to validate a gene signature in an independent dataset.
}
\details{
The z-score is based off of the geometric mean of expression. As such, negative expression values are not allowed. A dataset is thus always scaled by its minimum value + 1, such that the lowest value = 1. Any individual NANs or NAs are also set to 1. If a dataset does not have any information on a given gene, the entire gene is simply left out of the score.
}
\examples{
violinPlot(tinyMetaObject$filterResults$pValueFDR0.05_es0_nStudies1_looaTRUE_hetero0, 
   tinyMetaObject$originalData$Whole.Blood.Study.1, 
     labelColumn="group")
}
\seealso{
\code{\link{filterGenes}},  \code{\link{runMetaAnalysis}}
}
\author{
Winston A. Haynes
}
\keyword{graphs}
\keyword{hplot}
