% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{meshCentroid}
\alias{meshCentroid}
\title{Mesh centroid}
\usage{
meshCentroid(mesh)
}
\arguments{
\item{mesh}{a mesh given either as a list containing (at least) the two fields 
\code{vertices} (numeric matrix with three columns) and \code{faces} (integer 
matrix or list of integer vectors), otherwise as a \strong{rgl} mesh (i.e. a 
\code{mesh3d} object)}
}
\value{
The centroid of the mesh given as a numeric vector.
}
\description{
Computes the centroid of a closed mesh.
}
\examples{
\donttest{library(MeshesTools)
mesh <- cyclideMesh(a = 97, c = 32, mu = 57)
meshCentroid(mesh)}
}
