% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexPartsR.R
\name{convexParts}
\alias{convexParts}
\title{Decomposition into convex parts}
\usage{
convexParts(mesh, triangulate = TRUE)
}
\arguments{
\item{mesh}{either a list containing the fields \code{vertices} and 
\code{faces}, otherwise a \strong{rgl} mesh (i.e. a \code{mesh3d} object)}

\item{triangulate}{Boolean, whether to triangulate the convex parts}
}
\value{
A list of \code{cgalMesh} lists (see 
  \code{\link[PolygonSoup:Mesh]{Mesh}}), each corresponding to a convex part.
}
\description{
Decomposition of a mesh into convex parts.
}
\examples{
# a non-convex polyhedron ####
library(MeshesTools)
library(rgl)
library(randomcoloR)
meshes <- convexParts(mesh = NonConvexPolyhedron)
ncp <- length(meshes)
colors <- randomColor(ncp, hue = "random", luminosity = "bright")
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.8)
for(i in seq_len(ncp)){
  shade3d(toRGL(meshes[[i]]), color = colors[i])
}

# pentagrammic prism ####
library(MeshesTools)
library(rgl)
library(randomcoloR)
data(pentagrammicPrism, package = "PolygonSoup")
meshes <- convexParts(mesh = pentagrammicPrism)
ncp <- length(meshes)
colors <- randomColor(ncp, hue = "random", luminosity = "bright")
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.8)
for(i in seq_len(ncp)){
  shade3d(toRGL(meshes[[i]]), color = colors[i])
}
}
