% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_mvegger-methods.R
\docType{methods}
\name{mr_mvegger}
\alias{mr_mvegger}
\alias{mr_mvegger,MRMVInput-method}
\title{Multivariable MR-Egger method}
\usage{
mr_mvegger(object, orientate = 1, correl = FALSE,
  distribution = "normal", alpha = 0.05)

\S4method{mr_mvegger}{MRMVInput}(object, orientate = 1, correl = FALSE,
  distribution = "normal", alpha = 0.05)
}
\arguments{
\item{object}{An \code{MRMVInput} object.}

\item{orientate}{The risk factor that genetic associations are orientated to. The univariable and multivariable versions of MR-Egger are both sensitive to the choice of parameterization of the genetic associations - which allele the associations are orientated with respect to (in other words, which allele is the effect allele). For univariable MR-Egger, this is resolved by setting the genetic associations with the exposure all to be positive. In multivariable MR-Egger, we have to choose which of the exposures to orientate the genetic associations to. The default option is \code{1}, meaning that genetic associations with the first exposure are set to be positive.}

\item{correl}{If the genetic variants are correlated, then this correlation can be accounted for. The matrix of correlations between must be provided in the \code{MRInput} object: the elements of this matrix are the correlations between the individual variants (diagonal elements are 1). If a correlation matrix is specified in the \code{MRInput} object, then \code{correl} is set to \code{TRUE}.}

\item{distribution}{The type of distribution used to calculate the confidence intervals. Options are \code{"normal"} (default) or \code{"t-dist"}.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}
}
\value{
The output from the function is an \code{MVEgger} object containing:

 \item{Model}{A character string giving the type of model used (\code{"random"}).}
 \item{Orientate}{The number corresponding to the risk factor that the genetic associations are orientated to.}
 \item{Exposure}{A character vector with the names given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Correlation}{The matrix of genetic correlations.}
 \item{Estimate}{A vector of the causal estimates (slope coefficient).}
 \item{StdError.Est}{Standard errors of the causal estimates.}
 \item{Pvalue.Est}{The p-values associated with the estimates using a normal or t-distribution (as specified in \code{distribution}).}
 \item{CILower.Est}{The lower bound of the causal estimates based on the estimated standard error and the significance level provided.}
 \item{CIUpper.Est}{The upper bound of the causal estimates based on the estimated standard error and the significance level provided.}
 \item{Intercept}{The value of the intercept estimate.}
 \item{StdError.Int}{Standard error of the intercept estimate.}
 \item{Pvalue.Int}{The p-value associated with the intercept.}
 \item{CILower.Int}{The lower bound of the intercept based on the estimated standard error and the significance level provided.}
 \item{CIUpper.Int}{The upper bound of the intercept based on the estimated standard error and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-values associated with the estimates (calculated as Estimate/StdError as per Wald test) using a normal or t-distribution (as specified in \code{distribution}).}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
 \item{RSE}{The estimated residual standard error from the regression model.}
 \item{Heter.Stat}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value: the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more variants may be pleiotropic.}
}
\description{
The \code{mr_mvegger} function performs multivariable Mendelian randomization via the MR-Egger method. This is implemented by multivariable weighted linear regression.
}
\details{
Multivariable MR-Egger is an extension of the MR-Egger method to deal with genetic variants that are associated with multiple risk factors.

We implement the method using multivariable weighted linear regression. If the variants are correlated, the method is implemented using generalized weighted linear regression; this is hard coded using matrix algebra.

The causal estimate is obtained by regression of the associations with the outcome on the associations with the risk factors, with the intercept estimated and weights being the inverse-variances of the associations with the outcome.
}
\examples{
mr_mvegger(mr_mvinput(bx = cbind(ldlc, hdlc, trig), bxse = cbind(ldlcse, hdlcse, trigse),
   by = chdlodds, byse = chdloddsse), orientate = 1)

}
\references{
Jessica Rees, Angela Wood, Stephen Burgess. Extending the MR?Egger method for multivariable Mendelian randomization to correct for both measured and unmeasured pleiotropy. Statistics in Medicine 2017; 36(29): 4705-4718. doi: 10.1002/sim.7492.
}
