\name{ADPopSelExample1}
\alias{ADPopSelExample1}
\title{
Simulation-based design of an adaptive trial with population selection (normally distributed endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a normally distributed primary efficacy endpoint (a larger value of this endpoint indicates a more favorable outcome). The efficacy and safety profiles of a single dose or regimen of an experimental treatment will be evaluated versus a control in two patient populations, namely, the overall population of patients and a pre-defined subset of patients with a biomarker-positive status. An adaptive design with two interim analyses will be used in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial) to support the following decision rules:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial will be terminated for futility if the predicted probability of success (conditional power) in the overall population is too low
    \item Population selection rule will be applied at the second interim analysis (IA2). The most promising population or populations will be selected for the final analysis (FA).
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 220 enrolled patients per arm will be utilized in this trial.
    \item The prevalence of biomarker-positive patients in the overall population is expected to be 50\%.
    \item The patient dropout rate at the end of the treatment period is equal to 10\%.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim looks will be taken after 40\% and 60\% of the patients complete the treatment period or drop out of the trial before completing the treatment period. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 20\%.
    \item The influence and interaction thresholds used in the population selection rule are set to 0.1 and 1.3. The conditions based on these thresholds are applied sequentially to determine if the final analysis should be performed in the overall population only, in the biomarker-positive population only or simultaneously in both populations. 
}
The treatment effect assumptions need to be specified within the biomarker-positive population as well as the complementary population (biomarker-negative population). A common effect will be assumed in the control arm, i.e., the mean and standard deviation of the primary efficacy endpoint will be 0 and 1, respectively, in the biomarker-positive and biomarker-negative populations. A stronger treatment effect will be assumed in the biomarker-positive subset compared to the complementary subset, i.e., the mean of 0.4 in biomarker-positive patients and the mean 0.25 in biomarker-negative patients with a common standard deviation of 1.

Key operating characteristics of the proposed adaptive design with population selection will be evaluated using the \code{\link{ADPopSel}} function based on 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report for this adaptive design can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADPopSelApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADPopSel}}, \code{\link{ADPopSelExample2}}, \code{\link{ADPopSelExample3}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Normal"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, treatment) 
parameters$sample_size = c(220, 220)

# Prevalence of biomarker-positive patients in the overall population
parameters$prevalence = 0.5

# Patient dropout rate
parameters$dropout_rate = 0.1

# Mean and SD in the control arm (biomarker-negative, biomarker-positive)
parameters$control_mean = c(0, 0)
parameters$control_sd = c(1, 1)

# Mean and SD in the treatment arm (biomarker-negative, biomarker-positive)
parameters$treatment_mean = c(0.25, 0.4)
parameters$treatment_sd = c(1, 1)

# Information fractions at IA1, IA2, FA
parameters$info_frac = c(0.4, 0.6, 1)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.2

# Influence threshold at IA2
parameters$influence = 0.1

# Interaction threshold at IA2
parameters$interaction = 1.3

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations, you should prefer more
parameters$nsims = 100

# Run simulations to compute operating characteristics
results = ADPopSel(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADPopSel Normally distributed endpoint.docx", fileext=".docx"))
}