\name{replacemetvar}
\alias{replacemetvar}
\alias{replacemetdata}
\title{ Replace a weather variable}
\description{
  Replaces one (or more) of the weather variables in the met.dat file. 
}
\usage{
replacemetvar(replacevar, newvalues, oldmetfile="met.dat", 
	newmetfile="metNEW.dat")

replacemetdata(metdfr, oldmetfile = "met.dat", columns = NA, 
	newmetfile = "met.dat", khrs = NA)
}
\arguments{
  \item{replacevar}{ Character. Name(s) of the variable to be replaced.}
  \item{newvalues}{ Vector of new values for the weather variable, 
  has to be the same length as the number of records in the met.dat file.}
  \item{oldmetfile}{ Default name of the met.dat file that will be modified.}
  \item{newmetfile}{ Name of the new met.dat file.}
  \item{metdfr}{Dataframe with met data, to be pasted into a met.dat file.}
  \item{columns}{Optional character string : if the 'Columns' statement in the met.dat file is to be replaced.}
  \item{khrs}{Optional. Number of timesteps per day (by default, read from the met.dat file).}
}
\value{
  Returns nothing.
}
\author{ Remko Duursma}

\examples{

\dontrun{

#:::1.::: Replace precipitation with random number between 0 and 2.
# First find out how many records there are:
nrecords <- nrow(readmet("met.dat"))

# Make new rain
newrain <- runif(nrecords, 0, 2)

# And replace
replacemetvar("PPT",newrain,"met.dat", "newmet.dat")


#:::2.::: Replace multiple weather variables.
newtair <- runif(nrecords, 0, 35)

# Have to make a matrix of the variables to be replaced:
newmat <- matrix(cbind(newrain, newtair),ncol=2)

# And give a vector of variable names --in the same order as in the matrix!!--.
replacemetvar(c("PPT","TAIR"), newmat, "met.dat", "newmet.dat")


}

}

\keyword{ utilities}
