% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{settings}
\alias{settings}
\title{MachineShop Settings}
\usage{
settings(...)
}
\arguments{
\item{...}{character names of settings to view, \code{name = value} pairs
giving the values of settings to change, a vector of these, \code{"reset"}
to restore all package defaults, or no arguments to view all settings.
Partial matching of setting names is supported.}
}
\value{
The setting value if only one is specified to view.  Otherwise, a
list of the values of specified settings as they existed prior to any
requested changes.  Such a list can be passed as an argument to
\code{settings} to restore their values.
}
\description{
Allow the user to view or change global settings which affect default
behaviors of functions in the \pkg{MachineShop} package.
}
\section{Settings}{


\describe{
  \item{\code{\link[=controls]{control}}}{function, function name, or call
    defining a default resampling method [default: \code{"CVControl"}].}
  \item{\code{cutoff}}{numeric (0, 1) threshold above which binary factor
    probabilities are classified as events and below which survival
    probabilities are classified [default: 0.5].}
  \item{\code{distr.SurvMeans}}{character string specifying distributional
    approximations to estimated survival curves for predicting survival
    means.  Choices are \code{"empirical"} for the Kaplan-Meier estimator,
    \code{"exponential"}, \code{"rayleigh"}, or \code{"weibull"} (default).}
  \item{\code{distr.SurvProbs}}{character string specifying distributional
    approximations to estimated survival curves for predicting survival
    events/probabilities.  Choices are \code{"empirical"} (default) for the
    Kaplan-Meier estimator, \code{"exponential"}, \code{"rayleigh"}, or
    \code{"weibull"}.}
  \item{\code{grid}}{\code{size} argument to \code{\link{Grid}} indicating
    the number of parameter-specific values to generate automatically for
    \link[=TunedModel]{tuning} of models that have pre-defined grids or a
    \code{\link{Grid}} function, function name, or call [default: 3].}
  \item{\code{method.EmpiricalSurv}}{character string specifying the
    empirical method of estimating baseline survival curves for Cox
    proportional hazards-based models.  Choices are \code{"breslow"} or
    \code{"efron"} (default).}
  \item{\code{metrics.ConfusionMatrix}}{function, function name, or vector of
    these with which to calculate \link{performance} \link{metrics} for
    confusion matrices [default: \code{c(Accuracy = "accuracy", Kappa =
    "kappa2", `Weighted Kappa` = "weighted_kappa2", Sensitivity =
    "sensitivity", Specificity = "specificity")}].}
  \item{\code{metrics.factor}}{function, function name, or vector of these
    with which to calculate \link{performance} \link{metrics} for factor
    responses [default: \code{c(Brier = "brier", Accuracy = "accuracy",
    Kappa = "kappa2", `Weighted Kappa` = "weighted_kappa2", `ROC AUC` =
    "roc_auc", Sensitivity = "sensitivity", Specificity = "specificity")}].}
  \item{\code{metrics.matrix}}{function, function name, or vector of these
    with which to calculate \link{performance} \link{metrics} for matrix
    responses [default: \code{c(RMSE = "rmse", R2 = "r2", MAE = "mae")}].}
  \item{\code{metrics.numeric}}{function, function name, or vector of these
    with which to calculate \link{performance} \link{metrics} for numeric
    responses [default: \code{c(RMSE = "rmse", R2 = "r2", MAE = "mae")}].}
  \item{\code{metrics.Surv}}{function, function name, or vector of these with
    which to calculate \link{performance} \link{metrics} for survival
    responses [default: \code{c(`C-Index` = "cindex", Brier = "brier",
    `ROC AUC` = "roc_auc", Accuracy = "accuracy")}].}
  \item{\code{print_max}}{number of models or data rows to show with print
    methods or \code{Inf} to show all [default: 10].}
  \item{\code{require}}{names of installed packages to load during parallel
    execution of resampling algorithms [default: \code{c("MachineShop",
    "survival", "recipes")}].}
  \item{\code{resample_progress}}{logical indicating whether to display a
    progress bar during resampling [default: \code{TRUE}].  Displayed only
    if a computing cluster is not registered or is registered with the
    \pkg{doSNOW} package.}
  \item{\code{resample_verbose}}{logical indicating whether to enable verbose
    messages when resampling [default: \code{FALSE}].}
  \item{\code{reset}}{character names of settings to reset to their default
    values.}
  \item{\code{RHS.formula}}{non-modifiable character vector of operators and
    functions allowed in traditional formula specifications.}
  \item{\code{stat.Curve}}{function or character string naming a function
    to compute one \link{summary} statistic at each cutoff value of resampled
    metrics in performance curves, or \code{NULL} for resample-specific
    metrics [default: \code{"base::mean"}].}
  \item{\code{stat.Resamples}}{function or character string naming a function
    to compute one summary statistic to control the ordering of models in
    \link[=plot]{plots} [default: \code{"base::mean"}].}
  \item{\code{stat.Trained}}{function or character string naming a function
    to compute one summary statistic on resampled performance metrics for
    input \link[=SelectedInput]{selection} or \link[=TunedInput]{tuning} or
    for model \link[=SelectedModel]{selection} or \link[=TunedModel]{tuning}
    [default: \code{"base::mean"}].}
  \item{\code{stats.PartialDependence}}{function, function name, or vector of
    these with which to compute \link[=dependence]{partial dependence}
    summary statistics [default: \code{c(Mean = "base::mean")}].}
  \item{\code{stats.Resamples}}{function, function name, or vector of these
    with which to compute \link{summary} statistics on resampled performance
    metrics [default: \code{c(Mean = "base::mean", Median = "stats::median",
    SD = "stats::sd", Min = "base::min", Max = "base::max")}].}
}
}

\examples{
## View all current settings
settings()

## Change settings
presets <- settings(control = "BootControl", grid = 10)

## View one setting
settings("control")

## View multiple settings
settings("control", "grid")

## Restore the previous settings
settings(presets)

}
