% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_GLMNetModel.R
\name{GLMNetModel}
\alias{GLMNetModel}
\title{GLM Lasso or Elasticnet Model}
\usage{
GLMNetModel(family = NULL, alpha = 1, lambda = 0,
  standardize = TRUE, intercept = NULL, penalty.factor = .(rep(1,
  nvars)), standardize.response = FALSE, thresh = 1e-07,
  maxit = 1e+05, type.gaussian = .(ifelse(nvars < 500, "covariance",
  "naive")), type.logistic = c("Newton", "modified.Newton"),
  type.multinomial = c("ungrouped", "grouped"))
}
\arguments{
\item{family}{optional response type.  Set automatically according to the
class type of the response variable.}

\item{alpha}{elasticnet mixing parameter.}

\item{lambda}{regularization parameter.  The default value \code{lambda = 0}
performs no regularization and should be increased to avoid model fitting
issues if the number of predictor variables is greater than the number of
observations.}

\item{standardize}{logical flag for predictor variable standardization, prior
to model fitting.}

\item{intercept}{logical indicating whether to fit intercepts.}

\item{penalty.factor}{vector of penalty factors to be applied to each
coefficient.}

\item{standardize.response}{logical indicating whether to standardize
\code{"mgaussian"} response variables.}

\item{thresh}{convergence threshold for coordinate descent.}

\item{maxit}{maximum number of passes over the data for all lambda values.}

\item{type.gaussian}{algorithm type for guassian models.}

\item{type.logistic}{algorithm type for logistic models.}

\item{type.multinomial}{algorithm type for multinomial models.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit a generalized linear model via penalized maximum likelihood.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{matrix}, \code{numeric},
    \code{Surv}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{lambda}, \code{alpha}
  }
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = GLMNetModel(lambda = 0.01))

}
\seealso{
\code{\link[glmnet]{glmnet}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
