% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdev.R
\name{sdev}
\alias{sdev}
\title{Spatial Deviation}
\usage{
sdev(x, var1, var2, type = "rel", spdf, order = NULL, dist = NULL,
  mat = NULL, spdfid = NULL, xid = NULL)
}
\arguments{
\item{x}{a data frame.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{type}{type of deviation; "rel" for relative deviation, "abs" for 
absolute deviation (see Details).}

\item{spdf}{a SpatialPolygonsDataFrame that matches x data frame.}

\item{order}{contiguity order.}

\item{dist}{distance threshold defining the contiguity. The cartesian 
distance between units centroids is used by default 
(see \code{\link{gDistance}}); use mat to apply different metrics.}

\item{mat}{a distance matrix (road distance, travel time...) between x units. 
Row and column names must fit xid identifiers. (optional)}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{xid}{identifier field in x, default to the first column 
of x. (optional)}
}
\value{
A vector is returned.
}
\description{
This function computes the deviation between regional ratios and 
local ratios. Local ratios are defined either by a contiguity order or by a 
distance measure between regions.
Each elementary unit value will be compared to the value of its 
neighborhood.
}
\details{
The relative spatial deviation is the ratio between var1/var2 and 
var1/var2 in the specified neighborhoud. Values greater than 100 indicate 
that the unit ratio is greater than the ratio in its neighborhoud. Values 
lower than 100 indicate that the unit ratio is lower than the ratio in its 
neighborhoud.\cr
The absolute spatial deviation is the amount of numerator that could be 
moved to obtain the same ratio in all units of its neighborhoud.
}
\examples{
# load data
data("GrandParisMetropole")
# compute absolute spatial deviation in a neighborhood defined by a contiguity 
# order of 2.
com$sdevabs <- sdev(x = com, var1 = "INC", var2 = "TH", 
                          type = "abs", spdf = com.spdf, order = 2)

# compute relative spatial deviation in a neighborhood defined within a distance 
# of 5km between communes' centroids 
com$sdevrel <- sdev(x = com, var1 = "INC", var2 = "TH", type = "rel", 
                          spdf = com.spdf, dist = 5000)

# compute absolute spatial deviation in a neighborhood defined within a road 
# travel time of 10 minutes by car
com$scardevabs <- sdev(x = com, var1 = "INC", var2 = "TH", type = "abs", 
                             spdf = com.spdf, dist = 10, mat = cardist)
# compute relative spatial deviation in a neighborhood defined within a road 
# travel time of 10 minutes by car
com$scardevrel <- sdev(x = com, var1 = "INC", var2 = "TH", type = "rel", 
                             spdf = com.spdf, dist = 10, mat = cardist)

# map deviations
if(require('cartography')){
  # set graphical parameters
  par(mar = c(0,0,1.2,0))
  # set breaks
  bks <- c(min(com$scardevrel),50,75,100,125,150,max(com$scardevrel))
  bks <- sort(bks)
  # set colot palette
  cols <- carto.pal(pal1 = "blue.pal", n1 = 3,
                    pal2 = "wine.pal", n2 = 3)
  # plot a choropleth map of the relative spatial deviation
  choroLayer(spdf = com.spdf, df = com, var = "scardevrel",
             legend.pos = "topleft",
             legend.title.txt = "Relative Deviation",
             breaks = bks, border = NA,
             col = cols)
  # add symbols proportional to the absolute spatial deviation
  propSymbolsLayer(spdf = com.spdf, df = com, var = "scardevabs",
                   legend.pos = "left",legend.values.rnd = -5,
                   legend.title.txt = "Absolute Deviation",
                   col = "#ff000050",col2 = "#0000ff50",
                   legend.style = "e", inches = 0.2,
                   breakval = 0)
  # add a layout
  layoutLayer(title = "Spatial Deviation (neighborhoud: 10 minutes by car)",
              sources = "GEOFLA® 2015 v2.1, impots.gouv.fr", north = TRUE,
              author = "MTA")
}
}
