% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmsDxnoFSS.R
\name{spmsDx_no_fss}
\alias{spmsDx_no_fss}
\title{Diagnosis of secondary progressive multiple sclerosis without functional system scores and ambulation score}
\usage{
spmsDx_no_fss(
  visits,
  minEDSS = 4,
  tRelapse = 30,
  tProgression = 3 * 30.25,
  tRegression = 9 * 30.25,
  tRelProg = 6 * 30.25
)
}
\arguments{
\item{visits}{A dataframe consisting of 4 columns: ID, dateEDSS, EDSS, daysPostRelapse (days since most recent relapse).}

\item{minEDSS}{Minimum EDSS score to reach SPMS conversion.}

\item{tRelapse}{Minimum time in days from prior relapse to confirmation of EDSS progression.}

\item{tProgression}{SPMS confirmation period in days.}

\item{tRegression}{Confirmation period for EDSS improvement in days.}

\item{tRelProg}{Confirmation period (days) for rebaselining EDSS (after a relapse led to non-confirmed increase in EDSS).}
}
\value{
A data frame.
}
\description{
Diagnosis of conversion from relapsing-remitting multiple sclerosis (RRMS) to secondary progressive multiple sclerosis (SPMS), using the CORe definition without Functional System Scores (FSS) of Expanded Disability Status Scale (EDSS). Diagnosis is based on clinical visit records, each record including entries for patient code, visit date, EDSS score, and days since most recent relapse.
}
\examples{
data(SampleData)
output<-spmsDx_no_fss(SampleData)
}
\references{
Lorscheider J, et al. Brain 2016; 139 (9): 2395-2405.

Brown JW, et al. JAMA 2019; 321 (2): 175-87.

Lizak N, et al. JAMA neurology 2020; 77 (11): 1398-407.
}
