% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSGARCH.R
\docType{package}
\name{MSGARCH-package}
\alias{MSGARCH}
\alias{MSGARCH-package}
\title{The R package MSGARCH}
\description{
The \R package \pkg{MSGARCH} implements a comprehensive
set of functionalities for Markov-switching GARCH (Haas et al. 2004a) and Mixture of GARCH (Haas et al. 2004b) models,
This includes fitting, filtering, forecasting, and simulating.
Other functions related to Value-at-Risk and Expected-Shortfall are also available.\cr
The main functions of the package are coded
in \code{C++} using \pkg{Rcpp} (Eddelbuettel and Francois, 2011)
and \pkg{RcppArmadillo} (Eddelbuettel and Sanderson, 2014).\cr
\pkg{MSGARCH} focuses on the conditional variance (and higher moments) process.
Hence, there is no equation for the mean.
Therefore, you must pre-filter via AR(1) before applying the model.\cr
The \pkg{MSGARCH} package implements a variety of GARCH specifications together with several conditional distributions.
This allows for a rich modeling
environment for Markov-switching GARCH models. Each single-regime process
is a one-lag process (e.g., GARCH(1,1)).
When optimization is performed, we ensure that the variance in each regime is covariance-stationary
and strictly positive (refer to the vignette for more information).\cr
We refer to Ardia et al. (2017) \url{https://ssrn.com/abstract=2845809} for a detailed
introduction to the package and its usage.\cr
The authors acknowledge Google for financial support via the Google Summer of Code 2016 & 2017,
the International Institute of Forecasters and Industrielle-Alliance.
}
\references{
Ardia, D. Bluteau, K. Boudt, K. Catania, L. & Trottier, D.-A. (2017).
Markov-switching GARCH models in \R: The \pkg{MSGARCH} package.
\url{https://ssrn.com/abstract=2845809}

Eddelbuettel, D. & Francois, R. (2011).
\pkg{Rcpp}: Seamless \R and \code{C++} integration.
\emph{Journal of Statistical Software}, 40, 1-18.
\url{http://www.jstatsoft.org/v40/i08/}

Eddelbuettel, D. & Sanderson, C. (2014).
\pkg{RcppArmadillo}: Accelerating \R with high-performance \code{C++} linear algebra.
\emph{Computational Statistics & Data Analysis}, 71, 1054-1063.
\url{http://dx.doi.org/10.1016/j.csda.2013.02.005}

Haas, M. Mittnik, S. & Paolella, MS. (2004).
A new approach to Markov-switching GARCH models.
\emph{Journal of Financial Econometrics}, 2, 493-530.
\url{http://doi.org/10.1093/jjfinec/nbh020}

Haas, M. Mittnik, S. & Paolella, M. S. (2004b).
Mixed normal conditional heteroskedasticity.
\emph{Journal of Financial Econometrics}, 2, 211-250.
\url{http://doi.org/10.1093/jjfinec/nbh009}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/keblu/MSGARCH}
  \item Report bugs at \url{https://github.com/keblu/MSGARCH/issues}
}

}
\author{
\strong{Maintainer}: Keven Bluteau \email{Keven.Bluteau@unine.ch}

Authors:
\itemize{
  \item David Ardia \email{david.ardia.ch@gmail.com}
  \item Leopoldo Catania \email{leopoldo.catania@econ.au.dk}
  \item Denis-Alexandre Trottier \email{denis-alexandre.trottier.1@ulaval.ca}
}

Other contributors:
\itemize{
  \item Kris Boudt \email{kris.boudt@vub.ac.be} [contributor]
  \item Brian Peterson \email{brian@braverock.com} [contributor]
}

}
