% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_summary.R
\name{power_summary}
\alias{power_summary}
\title{Calculate sample size at a range of power levels.}
\usage{
power_summary(
  avail_pattern,
  f_t,
  g_t,
  beta,
  alpha,
  p_t,
  gamma,
  power_levels = seq(from = 0.6, to = 0.95, by = 0.05)
)
}
\arguments{
\item{avail_pattern}{A vector of length T that is the average availability at
each time point}

\item{f_t}{Defines marginal excursion effect MEE(t) under
alternative together with beta. Assumed to be matrix of size T*p.}

\item{g_t}{Defines success probability null curve together with
alpha. Assumed to be matrix of size T*q.}

\item{beta}{Length p vector that defines marginal excursion effect
MEE(t) under alternative together with f_t.}

\item{alpha}{Length q vector that defines success probability null
curve together with g_t.}

\item{p_t}{Length T vector of Randomization probabilities at each
time point.}

\item{gamma}{Desired Type I error}

\item{power_levels}{Vector of powers to find sample size for.}
}
\value{
Dataframe containing needed sample size to achieve
  user-specified power values.
}
\description{
Returns sample sizes needed to achieve a range of power levels for the hypothesis test
of marginal excursion effect (see Details) in the context of an MRT with binary outcomes
with small sample correction using F-distribution. See the vignette for
more details.
}
\details{
The sample size calculator is based on an asymptotic result with a small
sample correction. When the calculator finds out that a sample size less than
or equal to 10 is sufficient to attain the desired power, the calculator does
not output the exact sample size but produces an error message, because in
this situation the sample size result may not be as accurate. In general,
when the output sample size is small, one might reconsider the following: (1)
whether you are correctly or conservatively guessing the average of expected
availability, (2) whether the duration of study is too long, (3) whether the
treatment effect is overestimated, and (4) whether the power is set too low.
}
\examples{
           power_summary(tau_t_1, f_t_1, g_t_1,
                                   beta_1, alpha_1, p_t_1, 0.05)
}
