% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic.MRFA.R
\name{bic.MRFA}
\alias{bic.MRFA}
\title{Extract BIC from a Multiresolution Functional ANOVA (MRFA) Model}
\usage{
bic.MRFA(fit)
}
\arguments{
\item{fit}{a class MRFA object estimated by \code{MRFA_fit}.}
}
\value{
a vector with length \code{length(lambda)} returing BICs.
}
\description{
The function extracts Bayesian information criterion (BIC) from a fitted MRFA model.
}
\examples{
\dontrun{

#####             Testing function: GRAMACY & LEE (2009) function             #####
#####   Thanks to Sonja Surjanovic and Derek Bingham, Simon Fraser University #####
grlee09 <- function(xx)
{
  x1 <- xx[1]
  x2 <- xx[2]
  x3 <- xx[3]
  x4 <- xx[4]
  x5 <- xx[5]
  x6 <- xx[6]

  term1 <- exp(sin((0.9*(x1+0.48))^10))
  term2 <- x2 * x3
  term3 <- x4

  y <- term1 + term2 + term3
  return(y)
}

library(MRFA)
#####   Training data and testing data   #####
set.seed(2)
n <- 100; n_rep <- 3; n_new <- 50; d <- 6
X.train <- matrix(runif(d*n), ncol = d)
X.train <- matrix(rep(X.train, each = n_rep), ncol = d)
Y.train <- apply(X.train, 1, grlee09)
Y.train <- Y.train + rnorm(n*n_rep, 0, 0.05)
X.test <- matrix(runif(d*n_new), ncol = d)
Y.test <- apply(X.test, 1, grlee09)

#####   Fitting    #####
MRFA_model <- MRFA_fit(X.train, Y.train)
print(aic.MRFA(MRFA_model))
print(bic.MRFA(MRFA_model))

#####   Prediction : AIC and BIC  ######
X.test <- matrix(runif(d*n_new), ncol = d)
Y.test <- apply(X.test, 1, otlcircuit)
lambda.aic <- MRFA_model$lambda[which.min(aic.MRFA(MRFA_model))]
Y.pred <- predict(MRFA_model, X.test, lambda = lambda.aic)$y_hat
print(sqrt(mean((Y.test - Y.pred)^2)))

lambda.bic <- MRFA_model$lambda[which.min(bic.MRFA(MRFA_model))]
Y.pred <- predict(MRFA_model, X.test, lambda = lambda.bic)$y_hat
print(sqrt(mean((Y.test - Y.pred)^2)))
}
}
\author{
Chih-Li Sung <iamdfchile@gmail.com>
}
\seealso{
\code{\link{predict.MRFA}} for prediction of the MRFA model.
}

