#' print.moead
#'
#' S3 method for printing _moead_ objects (the output of [moead()]).
#'
#' @param x list object of class _moead_
#'            (generated by [moead()])
#' @param ... other parameters to be passed down to specific summary functions
#'            (currently unused)
#'
#' @examples
#' problem.1 <- list(name = "example_problem",
#'                   xmin = rep(-1,30),
#'                   xmax = rep(1,30),
#'                   m    = 2)
#' out <- moead(preset    = preset_moead("original2"),
#'              problem   = problem.1,
#'              stopcrit  = list(list(name = "maxiter",
#'                                    maxiter = 100)),
#'              showpars  = list(show.iters = "dots",
#'                               showevery  = 10))
#' print(out)
#'
#' @export
#'
#' @section References:
#' F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
#' Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
#' Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
#'

print.moead <- function(x, ...)
{

  # Error checking
  assertthat::assert_that("moead" %in% class(x))

  # ===========================================================================
  # Print
  cat("\nInput Configuration:\n")
  print(x$inputConfig)
  cat("\n#====================================")
  cat("\nTotal iterations: ", x$n.iter)
  cat("\nPopulation size: ", nrow(x$X))
  cat("\nEstimated ideal point: [", x$ideal, "]")
  cat("\nEstimated nadir point: [", x$nadir, "]")
  cat("\n#====================================")
  }
