% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSds.R
\name{getSds}
\alias{getSds}
\title{List SDS Layers in an .HDF File}
\usage{
getSds(HdfName, SDSstring = NULL, method = "gdal")
}
\arguments{
\item{HdfName}{\code{character}. (Absolute) filename from which to extract 
SDS names.}

\item{SDSstring}{\code{character}, see Value.}

\item{method}{\code{character}, defaults to \code{"gdal"}. Caution: on 
Windows, the default 'GDAL' installation doesn't support HDF4 files. Install 
'FWTools' or use \code{method = "mrt"} instead.}
}
\value{
A \code{list} or \code{character}. If \code{SDSstring} is provided, the 
function reports extracted SDS and a formatted SDSsting (e.g., "11101"). If 
not provided, the SDS names in \code{HdfName} are returned.  Consult the MRT 
manual for details.
}
\description{
This function lists the names of all scientific datasets (SDS) contained in a 
specified MODIS grid HDF file.
}
\examples{
\dontrun{
getSds(HdfName="XXX.hdf")
getSds(HdfName="/path/XXX.hdf",method="gdal") # require GDAL (FWTools on Windows)
getSds(HdfName="/path/XXX.hdf",method="mrt") # require MRTool
}

}
\author{
Matteo Mattiuzzi
}

