% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectBitInfo.R
\name{detectBitInfo}
\alias{detectBitInfo}
\title{List MODIS Quality Information}
\usage{
detectBitInfo(product, what = "all", warn = TRUE)
}
\arguments{
\item{product}{\code{character}, see \code{\link{getProduct}}.}

\item{what}{\code{character}. Parameter name, i.e. 
\url{https://lpdaac.usgs.gov/dataset_discovery/modis/modis_products_table/mod13q1}, 
(TABLE 2: MOD13Q1 VI Quality; Long Name).}

\item{warn}{\code{logical}, whether or not to throw warning messages.}
}
\value{
If \code{what = "all"} a \code{data.frame}, else a \code{list}.
}
\description{
This function returns MODIS QA information for a specific product. It gets 
the information from an internal database and not all products are available.
}
\examples{
detectBitInfo("MOD13Q1")
detectBitInfo("MOD13Q1", "VI usefulness")

detectBitInfo("MYD17A2")

}
\author{
Matteo Mattiuzzi
}

