% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fine_tuning.R
\name{fine_tuning}
\alias{fine_tuning}
\title{Fine Tune ML Model}
\usage{
fine_tuning(analysis_object, tuner, metrics = NULL, verbose = FALSE)
}
\arguments{
\item{analysis_object}{analysis_object created from build_model function.}

\item{tuner}{Name of the Hyperparameter Tuner. A string of the tuner name: "Bayesian Optimization" or
"Grid Search CV".}

\item{metrics}{Metric used for Model Selection. A string of the name of metric (see Metrics). By default
either "rmse" (regression) or "roc_auc" (classification).}

\item{verbose}{Whether to show tuning process. Boolean TRUE or FALSE (default).}
}
\value{
An updated analysis_object containing the fitted model with optimized hyperparameters,
the tuning results, and all relevant workflow modifications. This object includes the final trained
model, the best hyperparameter configuration, tuning diagnostics, and, if applicable, plots of the
tuning process. It can be used for further model evaluation, prediction, or downstream analysis within
the package workflow.
}
\description{
The \strong{fine_tuning()} function performs automated hyperparameter optimization for ML workflows encapsulated
within an AnalysisObject. It supports different tuning strategies, such as \strong{Bayesian Optimization} and
\strong{Grid Search Cross-Validation}, allowing the user to specify evaluation metrics and whether to visualize
tuning results. The function first validates arguments and updates the workflow and metric settings within
the AnalysisObject. If hyperparameter tuning is enabled, it executes the selected tuning procedure,
identifies the best hyperparameter configuration based on the specified metrics, and updates the workflow
accordingly. For neural network models, it also manages the creation and integration of new model instances
and provides additional visualization of training dynamics. Finally, the function fits the optimized model to
the training data and updates the AnalysisObject, ensuring a reproducible and efficient model selection process
(Bartz et al., 2023).
}
\section{Tuners}{

\subsection{Bayesian Optimization}{
\itemize{
\item Initial data points: 20
\item Maximum number of iterations: 25
\item Convergence after 5 iterations without improvement
\item Train / Validation / Test : 0.6 / 0.2 / 0.2
}
}

\subsection{Grid Search CV}{
\itemize{
\item Number of Folds: 5
\item Maximum levels per hyperparameter: 10
\item Train / Test : 0.75 / 0.25
}
}
}

\section{Metrics}{

\subsection{Regression Metrics}{
\itemize{
\item rmse
\item mae
\item mpe
\item mape
\item ccc
\item smape
\item rpiq
\item rsq
}
}

\subsection{Classification Metrics}{
\itemize{
\item accuracy
\item bal_accuracy
\item recall
\item sensitivity
\item specificity
\item kap
\item f_meas
\item mcc
\item j_index
\item detection_prevelance
\item roc_auc
\item pr_auc
\item gain_capture
\item brier_class
\item roc_aunp
}
}
}

\examples{
# Example 1: Fine tuning function applied to a regression task

library(MLwrap)

data(sim_data) # sim_data is a simulated dataset wtih psychological variables

wrap_object <- preprocessing(
           df = sim_data,
           formula = psych_well ~ depression + emot_intel + resilience + life_sat,
           task = "regression"
           )

wrap_object <- build_model(
               analysis_object = wrap_object,
               model_name = "Random Forest",
               hyperparameters = list(
                     mtry = 3,
                     trees = 50
                     )
                 )

wrap_object <- fine_tuning(wrap_object,
                tuner = "Grid Search CV",
                metrics = c("rmse")
               )

# Extracting Evaluation Results

table_best_hyp <- table_best_hyperparameters(wrap_object)
table_results <- table_evaluation_results(wrap_object)

# Plotting Results

wrap_object |>
  plot_tuning_results() |>
  plot_residuals_distribution() |>
  plot_scatter_residuals()

}
\references{
Bartz, E., Bartz-Beielstein, T., Zaefferer, M., & Mersmann, O. (2023). \emph{Hyperparameter
tuner for Machine and Deep Learning with R. A Practical Guide}. Springer, Singapore.
https://doi.org/10.1007/978-981-19-5170-1
}
