% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miSIPW.R
\name{miSIPW}
\alias{miSIPW}
\title{Fit a geeglm model using miSIPW}
\usage{
miSIPW(
  data,
  formula,
  id,
  visit,
  family,
  init.beta = NULL,
  init.alpha = NULL,
  init.phi = NULL,
  tol = 0.001,
  weights = NULL,
  corstr = "independent",
  maxit = 50,
  m = 2,
  pMat,
  method = NULL
)
}
\arguments{
\item{data}{longitudinal data set where each subject's outcome has been measured at same time points and number
 of visits for each patient is similar.
Covariance structure of the outcome variable like "unstuctured","independent","AR-1"
,"exchageable"}

\item{formula}{formula for the response model}

\item{id}{column name of id of subjects in the dataset}

\item{visit}{column name of timepoints of visit in the dataset}

\item{family}{name of the distribution for the response variable, For more information on how to use \code{family} objects, see \code{\link{family}}}

\item{init.beta}{initial values for the regression coefficient of GEE model}

\item{init.alpha}{initial values for the correlation structure}

\item{init.phi}{initial values for the scale parameter}

\item{tol}{tolerance in calculation of coefficients}

\item{weights}{A vector of weights for each observation. If an observation has weight 0, it is excluded from the calculations of any parameters. Observations with a NA anywhere (even in variables not included in the model) will be assigned a weight of 0. Weights are updated as the mentioned the details.}

\item{corstr}{a character string specifying the correlation structure. It could "independence", "exchangeable", "AR-1", "unstructured"}

\item{maxit}{maximum number iteration for newton-raphson}

\item{m}{number of imputation used to update the missing score function value due incomplete data.}

\item{pMat}{pMat predictor matrix as obtained in \code{\link{mice}}}

\item{method}{method option for mice model,for information see \link{mice}}
}
\value{
A list of objects containing the following objects
\describe{
  \item{call}{details about arguments passed in the function}
  \item{beta}{estimated regression coeffictient value for the response model}
  \item{niter}{number of iteration required}
  \item{betalist}{list of beta values at different iteration}
  \item{weight}{estimated weights for the observations}
  \item{mu}{mu values according \link{glm}}
  \item{phi}{etsimated phi value for the \code{glm} model}
  \item{hessian}{estimated hessian matrix obtained from the last iteration}
  \item{betaSand}{sandwich estimator value for the variance covariance matrix of the beta}
}
}
\description{
provides simple inverse probability weighted estimates of parameters for GEE model
of response variable using different covariance structure, missing values in covariates are multiply imputed for those subjects whose response is observed.
}
\details{
miSIPW

It uses the simple inverse probability weighted method to reduce the bias
due to missing values in GEE model for longitudinal data. The response variable \eqn{\mathbf{Y}} is related to the coariates as \eqn{g(\mu)=\mathbf{X}\beta}, where \code{g} is the link function for the glm. The estimating equation is
\deqn{\sum_{i=1}^{k}\sum_{j=1}^{n}\frac{\delta_{ij}}{\pi_{ij}}S(Y_{ij},\mathbf{X}_{ij},\mathbf{X}'_{ij})}=0
where \eqn{\delta_{ij}=1} if there is missing no value in covariates and 0 otherwise.
\eqn{\mathbf{X}} is fully observed all subjects and \eqn{\mathbf{X}'} is partially missing.
}
\examples{
 \dontrun{
##
formula<-C6kine~ActivinRIB+ActivinRIIA+ActivinRIIAB+Adiponectin+AgRP+ALCAM
pMat<-mice::make.predictorMatrix(srdata1[names(srdata1)\%in\%all.vars(formula)])
m1<-miSIPW(data=srdata1,
formula=formula,id='ID',
visit='Visit',family='gaussian',init.beta = NULL,
init.alpha=NULL,init.phi=1,tol=0.001,weights = NULL,
corstr = 'exchangeable',maxit=50,m=2,pMat=pMat)
##
}
}
\references{
Wang, C. Y., Shen-Ming Lee, and Edward C. Chao. "Numerical equivalence of imputing scores and weighted estimators in regression analysis with missing covariates." Biostatistics 8.2 (2007): 468-473.

Seaman, Shaun R., and Stijn Vansteelandt. "Introduction to double robust methods for incomplete data." Statistical science: a review journal of the Institute of Mathematical Statistics 33.2 (2018): 184.

Vansteelandt, Stijn, James Carpenter, and Michael G. Kenward. "Analysis of incomplete data using inverse probability weighting and doubly robust estimators." Methodology: European Journal of Research Methods for the Behavioral and Social Sciences 6.1 (2010): 37.
}
\seealso{
\link{SIPW},\link{AIPW},\link{miAIPW}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
