% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReplMatch_func_20200914.R
\name{ReplMatch}
\alias{ReplMatch}
\title{ReplMatch() function}
\usage{
ReplMatch(repl_table, seq_table, path_out)
}
\arguments{
\item{repl_table}{is a table containing the sample names of technical
replicates in the data set. This table should be organized so that the
individual names are in the first column (Sample_ID), and the index number
of the replicate set is in the second column (Replic_set). Replicate sets
are allowed to contain more than two replicates. It is assumed that
replicate sets are numbered consecutively beginning at 1.}

\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A set of R lists containing for each replicate set the observed
  sequence variants, the names of the sequences that were incongruent in the
  replicates, and the mean proportion of incongruent sequences (if 100%
  matches are expected between the replicates, this is equivalent of an error
  rate in the sequencing process). The sequences are named in the output by
  an index number corresponding to their column number in the sequence table,
  thus identical sequences will have identical sample names in all the output
  files. These files can be reopened in R e.g. using the readRDS() function
  in the base package.
}
\description{
In amplicon filtering it is sometimes valuable to compare technical
replicates in order to estimate the accuracy of a genotyping experiment. This
may be done both to optimize filtering settings and to estimate repeatability
to report in a publication. \code{\link{ReplMatch}} is designed to
automatically compare technical replicates in an amplicon filtering data set
and report the proportion of mismatches. The functions GetReplTable() and
GetReplStats() are designed to evaluate the output files.
}
\details{
If you publish data produced with MHCtools, please cite:
Roved, J. 2020. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., Westerdahl, H. 2020.
Non-random association of MHC-I alleles in favor of high diversity haplotypes
in wild songbirds revealed by computer-assisted MHC haplotype inference using
the R package MHCtools. bioRxiv.
}
\examples{
repl_table <- replicates_table
seq_table <- sequence_table_repl
path_out <- tempdir()
ReplMatch(repl_table, seq_table, path_out)
}
\seealso{
\code{\link{GetReplTable}}; \code{\link{GetReplStats}}; for more
  information about 'dada2' visit <https://benjjneb.github.io/dada2/>
}
