% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCSIS.R
\name{DCSIS}
\alias{DCSIS}
\title{Feature Screening via Distance Correlation Learning}
\usage{
DCSIS(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by DCSIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A sure independence screening procedure based on the distance correlation (DC-SIS).
The DC-SIS can be implemented as easily as the sure independence screening (SIS) procedure based on the Pearson correlation proposed by Fan and Lv(2008).
DC-SIS can be used directly to screen grouped predictor variables and multivariate response variables.
}
\examples{

n=100;
p=200;
pho=0.5;
data=gendata1(n,p,pho)
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A=DCSIS(X,Y,n/log(n));A

}
\references{
Fan, J. and J. Lv (2008). Sure independence screening for ultrahigh dimensional feature space. Journal of the Royal Statistical Society: Series B (Statistical Methodology) 70(5),849–911.

Li, R., W. Zhong, and L. Zhu (2012). Feature screening via distance correlation learning. Journal of the American Statistical Association 107(499), 1129–1139.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
