% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mainfun.R
\name{function_normalization}
\alias{function_normalization}
\title{Normalize raw ecosystem function values to [0,1]}
\usage{
function_normalization(
  data,
  fun_cols = 1:ncol(data),
  negative = NULL,
  by_group = NULL
)
}
\arguments{
\item{data}{data can be input as a data.frame with ecosystems/plots as rows and relevant ecosystem/plot information and ecosystem functions as columns. All missing values should be imputed in the input data. \cr
If the stratifying/grouping variable (specified in the argument \code{by_group}) is not \code{NULL}, data must contain a column that is used for stratification.}

\item{fun_cols}{the columns that represent ecosystem functions.}

\item{negative}{names of the negative functionality.}

\item{by_group}{the column name of the stratifying variable that is used to group data for performing normalization.
For example, if \code{by_group = "country"}, then all functions will be normalized to the range of [0, 1] within a country. Default is \code{NULL}.}
}
\value{
a data.frame with all values in functions (specified in \code{fun_cols}) being replaced by the transformed values between 0 and 1.
}
\description{
\code{function_normalization} transforms raw function values to values between 0 and 1. For positive functionality,
ecosystems with the highest value in the raw function data are transformed to the maximal value of 1, and those with the lowest raw value are transformed to the minimum value of 0.
Because the value "0" always implies absent functions, if the lowest raw value is not 0, the transformed 0 from this non-zero raw value will be replaced by a very small number,e.g., 10^(-5). 
In a similar manner, for negative functionality, if the highest raw value is not 0, the transformed 0 will also be replaced by a very small number, e.g., 10^(-5).
These replacements will not affect any numerical computations but will help indicate that the transformed values represent functions that should be regarded as "present" ones.
Thus, present or absent functions can be clearly distinguished in the transformed data, and the information on presence/absence of functions is required in the decomposition of multifunctionality
among ecosystems.
}
\examples{

library(dplyr)

### Use data from six countries

data("forest_function_data_raw")
function_normalization(data = forest_function_data_raw, fun_cols = 6:31,
                       negative = c("soil_cn_ff_10","wue"), by_group = "country")


### Use partial data to quickly obtain output 
### (Take the first 18 plots in Germany and the last 18 plots in Italy)

data("forest_function_data_raw")
GER_ITA_forest_function_raw <- filter(forest_function_data_raw, 
                                      country=="GER"|country=="ITA")[c(1:18,57:74),]
function_normalization(data = GER_ITA_forest_function_raw, fun_cols = 6:31,
                       negative = c("soil_cn_ff_10","wue"), by_group = "country")


}
