% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended.shared.R
\name{extended.shared}
\alias{extended.shared}
\alias{extended.shared.pedigree}
\alias{extended.shared.pedigreeList}
\title{Compute a common shared environment matrix}
\usage{
extended.shared(id, rho = 1, theta = 1, ...)

\method{extended.shared}{pedigreeList}(id, rho = 1, theta = 1, ...)

\method{extended.shared}{pedigree}(id, rho = 1, theta = 1, ...)
}
\arguments{
\item{id}{either a pedigree object or pedigreeList object}

\item{rho}{The correlation between spouses}

\item{theta}{The partial path coefficient from parents to offspring}

\item{\dots}{Any number of optional arguments. Not used at the moment}
}
\value{
a matrix of shared environment coefficients
}
\description{
Compute the common shared environment matrix for a set of related subjects.
The function is generic, and can accept a pedigree, or pedigreeList as the
first argument.
}
\details{
When called with a pedigreeList, i.e., with multiple families, the routine
will create a block-diagonal-symmetric `bdsmatrix' object.  Since the [i,j]
value of the result is 0 for any two unrelated individuals i and j and a
`bdsmatix' utilizes sparse representation, the resulting object is often
orders of magnitude smaller than an ordinary matrix.  When called with a
single pedigree and ordinary matrix is returned.
}
\examples{

library(kinship2)
test1 <- data.frame(id  =c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14),
                    mom =c(0, 0, 0, 0, 0, 2, 2, 4, 0,  6,  8,  0, 10, 11),
                    dad =c(0, 0, 0, 0, 0, 1, 1, 3, 0,  5,  7,  0,  9, 12),
                    sex =c(1, 2, 1, 2, 1, 2, 1, 2, 1,  2,  2,  1,  2,  2))

tped <- with(test1, pedigree(id, dad, mom, sex))
extended.shared(tped)

}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\seealso{
\code{pedigree}, \code{kinship},
}
\keyword{datagen}

