% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary.R
\name{binaryActionWriter}
\alias{binaryActionWriter}
\title{Function for writing actions of a HMDP model to binary files. The function defines
sub-functions which can be used to define actions saved in a set of binary
files. It is assumed that the states have been defined using \code{binaryMDPWriter}
and that the id of the states is known (can be retrieved using e.g. \code{stateIdxDf}).}
\usage{
binaryActionWriter(
  prefix = "",
  binNames = c("actionIdx.bin", "actionIdxLbl.bin", "actionWeight.bin",
    "actionWeightLbl.bin", "transProb.bin"),
  append = TRUE
)
}
\arguments{
\item{prefix}{A character string with the prefix added to \code{binNames}.}

\item{binNames}{A character vector of length 5 giving the names of the binary
files storing the model.}

\item{append}{Logical indicating whether should keep the currents actions (default - TRUE)
defined or delete them and start over (FALSE).}
}
\value{
A list of functions.
}
\description{
Binary files are efficient for storing large models. Compared to the HMP (XML)
format the binary files use less storage space and loading the model is faster.
}
\details{
The functions which can be used are: \itemize{
\item{\code{setWeights(labels, ...)}: }{Set the labels of the weights used in the actions.
\code{labels} is a vector of label names, \code{...} are not used.
The function must be called before starting building the model.}
\item{\code{addAction(label=NULL, sIdx, weights, prob, ...)}: }{Add an action. Parameter
\code{sIdx} is the id of the state defining the action, \code{weights} must be a vector of
action weights,
\code{prob} is a matrix \verb{(sIdx,pr)}  where the first column contain the id of the transition
state (see the description of \code{actionIdx.bin} below - scope is assumed to the 3), \code{...}
is currently not used.}
\item{\code{endAction()}: }{Ends an action.}
\item{\code{closeWriter()}: }{Close the writer. Must be called when the model description has
finished.}}

Five binary files are created using the following format:\itemize{
\item{\code{actionIdx.bin}: }{File of integers containing the indexes defining all actions in the format
\verb{sIdx scope idx scope idx scope idx -1 sIdx scope idx scope idx -1 sIdx scope -1 ...}.
\code{sIdx} corresponds to the index/line number in \code{stateIdx.bin} (index starts from 0).
Next pairs
\verb{(scope idx)} will follow indicating the possible transitions. Scope can be 4 values:
2 - A transition to a child process (stage zero in the child process), 1 - A transition
to next stage in the current process, 0 - A transition to the next stage in the father
process. Here \code{idx} in the pair denote the index of the state at the stage considered,
e.g. if scope=1 and \code{idx}=2 we consider state number 3 at next stage in the current
process. Finally, if scope = 3 then a transition to a state specified by it's state \code{sIdx}
is given. That is, if scope=3 and \code{idx}=5 then
we have a transition to the state specified at line 6 in \code{stateIdxLbl.bin}.
This is useful when considering shared child processes.}
\item{\code{actionIdxLbl.bin}: }{File of characters in the format \verb{aIdx label aIdx label ...} Here
\code{aIdx} corresponds to the index/line number in \code{actionIdx.bin} (index starts from 0).
Note no delimiter is used.}
\item{\code{actionWeight.bin}: }{File of doubles containing the weights of the actions in the format
"c1 c2 c3 c1 c2 c3 ..." assuming three weights for each action.}
\item{\code{actionWeightLbl.bin}: }{File of characters containing the labels of the
weights in the format \verb{label1 label2 label3} assuming three weights for each action. }
\item{\code{transProb.bin}: }{File of doubles containing the probabilities of the transitions
defined in actions in \code{actionIdx.bin}. The format is
"p1 p2 p3 -1 p1 -1 p1 p2 -1 ...". Here -1 is
used to indicate that a new action is considered (new line).}}
}
\note{
Note all indexes are starting from zero (C/C++ style).
}
\examples{
## Use temp dir
wd <- setwd(tempdir())

# Create a small HMDP with two levels
w<-binaryMDPWriter()
w$setWeights(c("Duration","Net reward","Items"))
w$process()
   w$stage()
      w$state(label="M0")
         w$action(label="A0",weights=c(0,0,0),prob=c(2,0,1))
            w$process()
               w$stage()
                  w$state(label="D")
                     w$action(label="A0",weights=c(0,0,1),prob=c(1,0,0.5,1,1,0.5))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
                     w$endAction()
                     w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
                     w$endAction()
                  w$endState()
                  w$state(label="C1")
                     w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
                     w$endAction()
                     w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                  w$endState()
                  w$state(label="C1")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                  w$endState()
               w$endStage()
            w$endProcess()
         w$endAction()
         w$action(label="A1",weights=c(0,0,0),prob=c(2,0,1))
            w$process()
               w$stage()
                  w$state(label="D")
                     w$action(label="A0",weights=c(0,0,1),prob=c(1,0,1))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
                     w$endAction()
                     w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                  w$endState()
                  w$state(label="C1")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                     w$action(label="A1",weights=c(0,10,5),prob=c(0,0,0.5,0,1,0.5))
                     w$endAction()
                  w$endState()
               w$endStage()
            w$endProcess()
         w$endAction()
      w$endState()
      w$state(label="M1")
         w$action(label="A0",weights=c(0,0,0),prob=c(2,0,1))
            w$process()
               w$stage()
                  w$state(label="D")
                     w$action(label="A0",weights=c(0,0,1),prob=c(1,0,0.5,1,1,0.5))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
                     w$endAction()
                  w$endState()
                  w$state(label="C1")
                     w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
                     w$endAction()
                  w$endState()
               w$endStage()
               w$stage()
                  w$state(label="C0")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                  w$endState()
                  w$state(label="C1")
                     w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1))
                     w$endAction()
                  w$endState()
               w$endStage()
            w$endProcess()
         w$endAction()
      w$endState()
   w$endStage()
w$endProcess()
w$closeWriter()

## Info about the binary files (don't have to load the model first)
getBinInfoStates()
getBinInfoActions()

## reset working dir
setwd(wd)
}
