% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBPCA.R
\name{MBPCA}
\alias{MBPCA}
\title{Multiblock Principal Components Analysis (MB-PCA)}
\usage{
MBPCA(
  X,
  group,
  algo = "eigen",
  ncompprint = NULL,
  scale = "none",
  option = "uniform",
  nstart = 10,
  threshold = 1e-08,
  plotgraph = TRUE,
  axes = c(1, 2)
)
}
\arguments{
\item{X}{Block obtained by horizontally merging all the blocks of variables.}

\item{group}{Vector which indicates the number of variables in each block.}

\item{algo}{Type of algorithm to use. Either "eigen" (default) or "nipals".}

\item{ncompprint}{Number of global components to print.
By default (NULL), all the global components of the analysis are printed.}

\item{scale}{Type of standardization applied to the variables. Either "none" (default) or "sd".
If scale="sd", each variable is divided by its standard deviation.}

\item{option}{Type of normalization applied to each block of variables (either "none" or "uniform").
If option="uniform" (default), each block of variables is divided by its Frobenius norm.}

\item{nstart}{Number of random initializations of the global component in case of nipals algorithm (by default 10).}

\item{threshold}{Value used to break the iterative loop (by default 1e-8).}

\item{plotgraph}{Boolean (TRUE/FALSE). If TRUE (default), graphs depicting scores of individuals, correlations of variables with the global components and contributions of blocks of variables to the determination of global components are displayed.}

\item{axes}{Vector of length two which specifies the global components to plot (by default the first two).}
}
\value{
Returns a list of the following elements:\cr

components  :  Numeric vector of length two that indicates the number of global components of the analysis and the number of global components to print.

optimalcrit  :  Numeric vector that gives the optimal value of the criterion to be maximized for each dimension.

cumexplained  :  Two columns matrix of percentages of total inertia of the blocks of variables explained by the successive global components and their cumulative values.

explained.X  :  Matrix of percentages of inertia explained in each Xb block.

contrib  :  Matrix of contribution of each Xb block to the determination of global components.

T  :  Matrix of global components (scores of individuals).

C  :  Compromise matrix (unnormed global components).

globalcor  :  Matrix of correlation coefficients between variables and global components.

cor.g.b  :  Array that gives the correlation of the global components with their respective block components.

\item{Block}{ : Results associated with each block Xb.
         \itemize{
               \item {T.b}{ : Array that contains the matrices of block components.}
               \item {blockcor}{ : List of matrices of correlation coefficients between the original variables of each block and the block components.}
       }}
}
\description{
Performs MB-PCA on a set of quantitative blocks of variables.
}
\examples{
data(ham)
X=ham$X
group=ham$group
res.mbpca <- MBPCA(X, group)
res.mbpca

}
\references{
S. Wold, S. Hellberg, T. Lundstedt, M. Sjostrom, H. Wold (1987). Hierarchical multiblock PLS and PC models for easier model interpretation and as an alternative to variable
selection, in: Proc. Symp. On PLS Model Building: Theory and Application, Frankfurt am Main.\cr

E. Tchandao Mangamana, V. Cariou, E. Vigneau, R. Glèlè Kakaï, E.M. Qannari (2019). Unsupervised multiblock data analysis: A unified approach and extensions, Chemometrics and Intelligent Laboratory Systems, 194, 103856.
}
\seealso{
\code{\link{print.MBPCA}}    \code{\link{plot.MBPCA}}    \code{\link{summary.MBPCA}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
