% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAVE.R
\name{MAVE}
\alias{MAVE}
\title{Dimension reduction}
\usage{
MAVE(x, y, method = "CSOPG")
}
\arguments{
\item{x}{The design matrix.}

\item{y}{The respond vector.}

\item{method}{This parameter specify which method will be used in dimension reduction. It provides
five methods, including "csMAVE","csOPG","meanOPG","meanMAVE","KSIR"
by default, method = 'csOPG'
\itemize{
\item 'meanOPG' and 'meanMAVE' estimate dimension reduction space
           for conditional mean
\item 'csMAVE' and 'csOPG' estimate the central dimension reduction
           space
\item 'KSIR' is a kernel version of sliced inverse regression (Li, 1991). It is fast, but
           with poor accuracy.
}}
}
\value{
rd is a list which contains:
\itemize{
\item dir: dir[[d]] is the central space with d-dimension
        d = 1, 2, ..., p reduced direction of different dimensions
\item x: parameter used for DIM for selection
\item ky: parameter used for DIM for selection
}
}
\description{
This function provides several methods to estimate the central space or central mean space of y on x.
 It returns the matrix of central space or central mean space for different dimensions and contains
 other information used for dimension selection by \code{\link{DIM}}.
}
\examples{
 x <- matrix(rnorm(200*5),200,5)
 b1 <- matrix(c(1,1,0,0,0),5,1)
 b2 <- matrix(c(0,0,1,1,0),5,1)
 eps <- matrix(rnorm(200),200,1)
 y <- x\%*\%b1 + (x\%*\%b2)*eps

 #finding central space based on OPG method
 rd.csopg <- MAVE(x,y,'csopg')
 
 #find central mean space based on MAVE method
 rd.meanopg <- MAVE(x,y,'meanopg')
 
 #find central mean space based on ksir method
 rd.ksir <- MAVE(x,y,'ksir')

}
\references{
Li K C. Sliced inverse regression for dimension reduction[J]. Journal of the American Statistical Association, 1991, 86(414): 316-327.

Xia Y, Tong H, Li W K, et al. An adaptive estimation of dimension reduction space[J]. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 2002, 64(3): 363-410.

Xia Y. A constructive approach to the estimation of dimension reduction directions[J]. The Annals of Statistics, 2007: 2654-2690.

Wang H, Xia Y. Sliced regression for dimension reduction[J]. Journal of the American Statistical Association, 2008, 103(482): 811-821.
}
\seealso{
\code{\link{DIM}} for dimension selection
}

