% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_03_EXPLORE_EXPRESSION_2_SJ.R
\name{PlotPctExprCells.SJ.10x}
\alias{PlotPctExprCells.SJ.10x}
\title{Plot splice junction expression distribution}
\usage{
PlotPctExprCells.SJ.10x(
  MarvelObject,
  cell.group.g1,
  cell.group.g2,
  min.pct.cells.genes = 10,
  min.pct.cells.sj = 10,
  downsample = FALSE,
  downsample.pct.sj = 10,
  seed = 1
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{cell.group.g1}{Vector of character strings. Cell IDs corresponding to Group 1 (reference group) of downstream differential splice junction analysis.}

\item{cell.group.g2}{Vector of character strings. Cell IDs corresponding to Group 2 of downstream differential splice junction analysis.}

\item{min.pct.cells.genes}{Numeric value. Minimum percentage of cells in which the gene is expressed for that gene to be included for splice junction expression distribution analysis. Expressed genes defined as genes with non-zero normalised UMI counts. This threshold may be determined from \code{PlotPctExprCells.SJ.10x} function.}

\item{min.pct.cells.sj}{Numeric value. Minimum percentage of cells in which the splice junction is expressed for that splice junction to be included for splice junction expression distribution analysis. Expressed splice junctions defined as splice junctions with raw UMI counts >= 1.}

\item{downsample}{Logical value. If set to \code{TRUE}, the splice junctions will be downsampled so that only a smaller number of splice junctions will be included for expression exploration analysis here. Default value is \code{FALSE}.}

\item{downsample.pct.sj}{Numeric value. If \code{downsample} set to \code{TRUE}, the minimum percentage of splice junctions to include for expression exploration analysis here.}

\item{seed}{Numeric value. To ensure the splice junctions downsampled will always be reproducible.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$pct.cells.expr$SJ$Plot} and \code{MarvelObject$pct.cells.expr$SJ$Data}
}
\description{
Generates a plot of splice junction expression distribution (percentage of cells expressing a particular splice junction) to determine splice junction expression threshold for downstream differential splice junction analysis.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # Group 1 (reference)
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Group 2
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

# Explore \% of cells expressing SJ
marvel.demo.10x <- PlotPctExprCells.SJ.10x(
                    MarvelObject=marvel.demo.10x,
                    cell.group.g1=cell.ids.1,
                    cell.group.g2=cell.ids.2,
                    min.pct.cells.genes=5,
                    min.pct.cells.sj=5,
                    downsample=TRUE,
                    downsample.pct.sj=100
                    )

marvel.demo.10x$pct.cells.expr$SJ$Plot
head(marvel.demo.10x$pct.cells.expr$SJ$Data)
}
