\name{Progesterone}
\encoding{UTF-8}
\docType{data}
\alias{Progesterone}
\title{Data sets: Progesterone level for detecting ectopic pregnancies and natural abortions.}
\description{Débordès & Plante (2015) extract data from figures in published articles. All papers show the level of progesterone as a diagnotic variable for ectopic pregnancies or natural abortions from other causes. The object \code{Progesterone} is a list of lists containing samples from the different papers from which data are obtained.}
\usage{data(Progesterone)}
\format{List of lists of vectors.}
\source{Data were extracted from ublished figures in Dumps et al. (2002), Florio et al. (2007), Gelder et al. (1991), Grosskinsky et al. (1993), Hanita et al. (2012), Ledger et al. (1994), O'leary et al. (1996), Peterson et al. (1992), Riss et al. (1989), Stewart et al.(1995), and Witt et al. (1990). All measurements are in nmol/l. Note that the data were \emph{extracted} from the \emph{figures} of the paper and as such, contain error due to their conversion back into numbers.
}

\references{
J.-B. Débordès & J.-F. Plante (2009). Combining ROC curves using MAMSE weighted distributions.
\emph{Cahier du GERAD G-2015-69}.

Dumps, P., Meisser, A., Pons, D., Morales, M. A., Anguenot, J.-L., Campana, A., and Bischof, P. (2002). Accuracy of single measurements of pregnancy-associated plasma protein-a, human chorionic gonadotropin and progesterone in the diagnosis of early pregnancy failure. European Journal of Obstetrics & Gynecology and Reproductive Biology 100, 174–180.

Florio, P., Severi, F. M., Bocchi, C., Luisi, S., Mazzini, M., Danero, S., Torricelli, M., and Petraglia, F. (2007). Single serum activin a testing to predict ectopic pregnancy. The Journal of Clinical Endocrinology & Metabolism 92, 1748–1753.

Gelder, M., Boots, L., and Younger, J. (1991). Use of a single random serum progesterone value as a diagnostic aid for ectopic pregnancy. Fertility and sterility 55, 497–500.

Grosskinsky, C., Hage, M., Tyrey, L., Christakos, A., and Hughes, C. (1993). hcg, progesterone, alpha-fetoprotein, and estradiol in the identification of ectopic pregnancy. Obstetrics and gynecology 81, 705–709.

Hanita, O., Hanisah, A., et al. (2012). Potential use of single measurement of serum progesterone in detecting early pregnancy failure. Malaysian J Pathol 34, 41–46.

Ledger, W., Sweeting, V., and Chatterjee, S. (1994). Rapid diagnosis of early ectopic pregnancy in an emergency gynaecology serviceare measurements of progesterone, intact and free \eqn{\beta} human chorionic gonadotrophin helpful? Human reproduction 9, 157–160.

O’Leary, P., Nichols, C., Feddema, P., Lam, T., and Aitken, M. (1996). Serum progesterone and human chorionic gonadotrophin measurements in the evaluation of ectopic pregnancy. Australian and New Zealand journal of obstetrics and gynaecology 36, 319–323.

Peterson, C., Kreger, D., Delgado, P., and Hung, T. (1992). Laboratory and clinical comparison of a rapid versus a classic progesterone radioimmunoassay for use in determining abnormal and ectopic pregnancies. American journal of obstetrics and gynecology 166, 562–566.

Riss, P. A., Radivojevic, K., and Bieglmayer, C. (1989). Serum progesterone and human, Biometrics, December 2015 chorionic gonadotropin in very early pregnancy: implications for clinical management. European Journal of Obstetrics & Gynecology and Reproductive Biology 32, 71–77.

Stewart, B. K., Nazar-Stewart, V., and Toivola, B. (1995). Biochemical discrimination of pathologic pregnancy from early, normal intrauterine gestation in symptomatic patients. American journal of clinical pathology 103, 386–390.

Witt, B., Wolf, G., Wainwright, C., Johnston, P., and Thorneycroft, I. (1990). Relaxin, ca-125, progesterone, estradiol, schwangerschaft protein, and human chorionic gonadotropin as predictors of outcome in threatened and nonthreatened pregnancies. Fertility and sterility 53, 1029–1036.
}

\keyword{datasets}
\seealso{
\link{roc}, link{healthy}.
}

