% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSingleRibbonPlot.R
\name{generateRibbonPlot}
\alias{generateRibbonPlot}
\title{Function to generate a ribbon plot depicting co-occurence and mutual exclusivity of gene mutations}
\usage{
generateRibbonPlot(
  maf,
  onco_genes = NULL,
  save_name = NULL,
  pval_high = 0.1,
  pval_low = 0.05,
  plot_type = "matrix",
  plot_frac_mut_axis = TRUE,
  rotate_plot_degrees = 0,
  shrink_factor = 1.3,
  scale_ribbon_to_fracmut = TRUE,
  sig_colors = NULL,
  gene_colors = NULL
)
}
\arguments{
\item{maf}{A MAF object}

\item{onco_genes}{A list of genes to restrict the analysis.  Passed to maftools::somaticInteractions()}

\item{save_name}{The name and path of the output PDF}

\item{pval_high}{All interactions with less than this p-value will be shown}

\item{pval_low}{Links with p-value less than this will be shown in a darker color}

\item{plot_type}{'ribbon' returns a customized chord diagram, 'matrix' returns the default somaticInteractions() plot}

\item{plot_frac_mut_axis}{Whether or not to draw a numerical axis on the perimeter}

\item{rotate_plot_degrees}{Rotate default layout by this many degrees}

\item{shrink_factor}{Higher values = more shrinkage; use to control whitespace (or lack thereof) around figure.  Mostly useful in 0.5 - 1.5 range.}

\item{scale_ribbon_to_fracmut}{Whether or not to scale ribbon widths to their frequency}

\item{sig_colors}{Vector of 4 colors for coloring significance}

\item{gene_colors}{Color(s) for gene segments.  By default, they're colored randomly.}
}
\value{
No return value. If 'save_name' is not provided, then the plot is printed to the current graphics device, otherwise a PDF is created at the given path.
}
\description{
This function provides an alternate visualization for maftools::somaticInteractions()
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
generateRibbonPlot(read.maf(maf),save_name=paste0(tempdir(),"/ribbonPlot.pdf"))

}
\author{
Mayank Tandon, Ashish Jain
}
