/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import com.sosnoski.util.hashmap.ObjectIntHashMap;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import uk.ac.rhul.cs.cl1.ClusterONE;
import uk.ac.rhul.cs.cl1.ClusterONEException;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSetList;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeTaskMonitorWrapper;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;

public class ClusterONECytoscapeTask
extends ClusterONE
implements Task {
    private CyNetwork network;
    private CyNetworkView networkView;
    private ResultListener resultListener;

    public CyNetwork getNetwork() {
        return this.network;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public void setNetwork(CyNetwork network) {
        this.network = network;
        if (this.networkView != null && this.networkView.getModel() != network) {
            this.networkView = null;
        }
    }

    public void setNetworkView(CyNetworkView networkView) {
        this.networkView = networkView;
        this.setNetwork(networkView != null ? (CyNetwork)networkView.getModel() : null);
    }

    public void setResultListener(ResultListener listener) {
        this.resultListener = listener;
    }

    public void cancel() {
        this.halt();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            this.setTaskMonitor(taskMonitor != null ? new CytoscapeTaskMonitorWrapper(taskMonitor) : null);
            taskMonitor.setTitle("ClusterONE");
            super.run();
            if (this.resultListener != null) {
                Result result = new Result();
                result.clusters = this.result;
                if (this.graph instanceof Graph) {
                    result.nodeMapping = ((Graph)this.graph).getNodeMapping();
                }
                this.resultListener.resultsCalculated(this, result);
            }
        }
        catch (ClusterONEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Unexpected error while running ClusterONE. Please notify the plugin authors!", e);
        }
    }

    public static interface ResultListener {
        public void resultsCalculated(ClusterONECytoscapeTask var1, Result var2);
    }

    public class Result {
        public ValuedNodeSetList clusters;
        public List<CyNode> nodeMapping;

        public void setStatusAttributes() {
            if (ClusterONECytoscapeTask.this.networkView == null || ClusterONECytoscapeTask.this.networkView.getModel() == null) {
                return;
            }
            ObjectIntHashMap occurrences = new ObjectIntHashMap();
            for (ValuedNodeSet nodeSet : this.clusters) {
                for (Integer nodeIdx : nodeSet) {
                    int value = occurrences.get(nodeIdx);
                    if (value == Integer.MIN_VALUE) {
                        value = 0;
                    }
                    occurrences.add(nodeIdx, value + 1);
                }
            }
            CyTable nodeTable = ClusterONECytoscapeTask.this.network.getDefaultNodeTable();
            String[] values = new String[]{"Outlier", "Cluster", "Overlap"};
            CyColumn statusColumn = nodeTable.getColumn("cl1.Status");
            if (statusColumn != null && statusColumn.getType() != String.class) {
                nodeTable.deleteColumn("cl1.Status");
                statusColumn = null;
            }
            if (statusColumn == null) {
                nodeTable.createColumn("cl1.Status", String.class, false);
            }
            int i = 0;
            for (CyNode node : this.nodeMapping) {
                CyRow row;
                int index = occurrences.get(i);
                if (index == Integer.MIN_VALUE) {
                    index = 0;
                }
                if (index > 2) {
                    index = 2;
                }
                if ((row = ClusterONECytoscapeTask.this.network.getRow((CyIdentifiable)node)) != null) {
                    row.set("cl1.Status", (Object)values[index]);
                }
                ++i;
            }
        }
    }
}

