% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELW_est.R
\name{ELW}
\alias{ELW}
\title{Exact local Whittle estimator of the fractional difference parameter d 
for stationary and non-stationary long memory.}
\usage{
ELW(data, m, mean.est = c("mean", "init", "weighted", "none"))
}
\arguments{
\item{data}{data vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{mean.est}{specifies the form of mean correction. One of \code{c("mean","init","weighted","none")}.}
}
\description{
\code{ELW} implements the exact local Whittle estimator of 
Shimotsu and Phillips (2005) that is consistent and asymptotically normal as long as 
the optimization range is less than 9/2, so that it is possible to estimate the memory
of stationary as well as non-stationary processes.
}
\examples{
library(fracdiff)
T<-1000
d<-0.8
series<-cumsum(fracdiff.sim(T,d=(d-1))$series)
ts.plot(series)
ELW(series, m=floor(1+T^0.7))$d
}
\references{
Shimotsu, K. and Phillips, P. C. B. (2005): Exact Local Whittle
Estimation Of Fractional Integration. The Annals of Statistics, Vol. 33, No. 4, pp. 1890 - 1933
}
\author{
Christian Leschinski
}
